#ifndef PIXLIB_H_READ
#define PIXLIB_H_READ

#include <malloc.h>

#ifndef major		/* major(x) is defined in types.h */
#include <sys/types.h>
#endif

#ifdef uts /* No BSD types */
#ifndef CITTYPES
typedef unsigned char u_char;
typedef unsigned short u_short;
#define CITTYPES
#endif
#endif

#ifndef L_SET
#define L_SET  0
#define L_INCR 1
#define L_XTND 2
#endif

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

/* Yow, are we portable yet? */
#define NullPtr(type) ((type *)NULL)

/* Macro to construct a pixel from 3 color components */
#define RGB8(r,g,b) ((((RGBPIXEL)b) << 16) | \
		     (((RGBPIXEL)g) << 8) | \
		      ((RGBPIXEL)r))

#define RGBA8(r,g,b,a) ((((RGBPIXEL)a) << 24) | RGB8(r,g,b))


/* Macros to extract the color and coverage components of a pixel */
#define GETRED(pix) ((pix) & 0xFF)
#define GETGRN(pix) GETRED(pix>>8)
#define GETBLU(pix) GETRED(pix>>16)
#define GETALP(pix) GETRED(pix>>24)

typedef long RGBPIXEL;	/* Type that can contain a 24-bit RGB pixel */
typedef u_char RPIXEL;	/* Type that can contain a single pixel */

#define CMAP_SIZE   256		/* # of entries in a color map */
#define LINE_LENGTH 2048	/* Maximum length of a scan line in pixels */
#define MAXLINE     LINE_LENGTH /* Max # of pixels on a line */

extern char *pixerrmess();

/* Rastertech hardware limits */
#define YT ( 255)
#define YB (-256)
#define XL (-256)
#define XR ( 255)

#include "lff.h"
#include "pix.h"
#include "pixerrno.h"

/* For portability between machines with different byte orders, we have
    several subroutines which are no-ops on a vax:
*/
#if defined(vax) || defined(mips)
#define VAX_ORDER
#define hdr_to_vax(X)
#define hdr_to_host(X)
#define pix_hdr_to_host(X)
#define tile_table_to_vax(X,L)
#define tile_table_to_host(X,L)
#define packet_to_vax(X)
#define packet_to_host(X)
/*
    Byte offsets into a longword for color/alpha components.
    VAX is a little-endian, with LSB first in a longword.
*/
#define OFF_R 0
#define OFF_G 1
#define OFF_B 2
#define OFF_A 3

#else
#if defined(sun)

#ifdef VAX_ORDER
#undef VAX_ORDER
#endif

extern void hdr_to_vax(), hdr_to_host(),
	    pix_hdr_to_host(),
	    tile_table_to_vax(), tile_table_to_host(),
	    packet_to_vax(), packet_to_host();

/*
    Byte offsets into a longword for color/alpha components.
    Big-endians have LSB last in a longword.
*/
#define OFF_R 3
#define OFF_G 2
#define OFF_B 1
#define OFF_A 0

#else /*!sun*/
fatal "Can't figure out machine byte order"
#endif
#endif

#endif	/* PIXLIB_H_READ */
