/*
    Pixio.h
    Standard header file for device-independent graphics routines
    Jon Leech May 27 1986
*/
#ifndef EINTR
#include <errno.h>
#endif

#define R (0)
#define G (1)
#define B (2)

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

typedef struct cmap_info {
    int bits[3];	/* Bits allocated to R, G, B planes */
    int mask[3];	/* Mask to take significant bits (after shifting) */
    int shift[3];	/* Amount to shift to get SBs */
    int backshift[3];	/* Amount to shift back to construct index */
} CMAP_INFO;

#define GR_SYSERR   -1
#define GR_NODEV    -2

/* Declarations of function types in the pixel I/O library */

#ifndef DECL
#ifdef c_plusplus
#define DECL(func, type) extern "C" func type
#else
#define DECL(func, type) func ()
#endif
#endif

/* Display-dependent code to actually poke at device */
DECL(int gr_open,    (const char *dev, const char *driver, int rows, int cols));
DECL(int gr_get_size,(int *rows, int *cols, int *bits));
DECL(int gr_get_desc,());
DECL(int gr_set_cmap,(int min, int len, float map[][3]));
DECL(int gr_write,   (int row, int col, int length, unsigned char *pixels));
DECL(int gr_select,  (int desc));
DECL(int gr_close,   ());

extern int gr_errno;

/* Utility functions */
DECL(int gr_make_cmap, (float map[][3], int nbits, int rb, int gb, int bb, cmap_info *map));
DECL(int gr_rgb_to_index, (int r, int g, int b, cmap_info *cmap));

/* Functions to transform RGB -> 8 bits in various ways */
DECL(void RGB_to_mono, (RGBPIXEL *rgb, unsigned char *mono, int length, CMAP_INFO *cmap));

DECL(void RGB_to_mono_with_magic_dither,(RGBPIXEL *rgb,unsigned char *mono,int length,int y,CMAP_INFO *cmap));

DECL(void RGB_to_mono_with_floyd_steinberg,(RGBPIXEL *rgb,unsigned char *mono,int length,int y,int ystart,CMAP_INFO *cmap));

/* Possible dithering schemes */
#define DITHER_NONE  (0)
#define DITHER_MAGIC (1)
#define DITHER_FLOYD (2)

#ifdef hp9000s200
#include <starbase.c.h>
/* Permute a color for our strange color map */
#define CMAPLEN 256

#define PERMUTE_COLOR(c) (c)
#define INV_PERMUTE_COLOR(c) (c)
#endif

#ifdef sun
#include <suntool/gfx_hs.h>
#define CMAPLEN 256

#define HOLDER	   (0)	    /* Three entries which are perturbed to leave */
#define FOREGROUND (254)    /*	text colors unchanged outside window */
#define BACKGROUND (255)
#define CMAPLEN    (256)    /* # of entries in 8-bit colormap */

/* Permute a color for our strange color map */
#define PERMUTE_COLOR(c) ((c) == HOLDER ? BACKGROUND : \
			  (c) == BACKGROUND ? FOREGROUND : \
			  (c) == FOREGROUND ? HOLDER : (c))

#define INV_PERMUTE_COLOR(c) ((c) == BACKGROUND ? HOLDER : \
			      (c) == FOREGROUND ? BACKGROUND : \
			      (c) == HOLDER ? FOREGROUND : (c))
#endif
