/*
    Definitions relevant to .pix files
*/

#ifndef PIX_H_READ
#define PIX_H_READ

typedef struct pix_hdr {
	u_char	magic,
		format,
		pad1,
		graylevel;	/*  4 bytes */
	u_short height,
		width;		/* +4 bytes */
	u_char	mask,
		block;		/* +2 bytes */
	u_short red_cmap,
		grn_cmap,
		blu_cmap;	/* +6 bytes */
	u_char	pad[496];	/* =16 + 496 = 512 == PIXBLKSIZE bytes in header */
} PIX_HDR;

#define PIX_MAGIC 157	    /* Magic number in all .pix files */

#define STANFORD_BW 1	    /* Format codes, we don't understand first 3 */
#define SUN	    3
#define NEC	    4
#define GRIN_PIX    128     /* PIXEL format red plane, green plane, blue plane */
#define GRIN_PACKED 129     /* PACKED PIXEL, red line, green line, blue line */
#define GRIN_BIT    130     /* Undefined */
#define GRIN_RLE    131     /* Run-length encoded format */

#define MAX_GRAYLEVEL 255
#define GRIN_SIZE     512

#define PIXBLKSIZE 512	    /* Size of a 'block' in a .pix file */
#define RED 0x1 	    /* Mask bits to tell which color planes are given */
#define GRN 0x2
#define BLU 0x4
#define BW  0x8

#endif	/* PIX_H_READ */
