/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _string.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#include <LEDA/basic.h>

#include <stdarg.h>
#include <string.h>
#include <ctype.h>


//------------------------------------------------------------------------------
// String
//------------------------------------------------------------------------------

 string_rep::string_rep(const char* p) { s = string::str_dup(p); }

 string_rep::string_rep(char c)   
 { char p[2];
   p[0] = c;
   p[1] = '\0';
   s=string::str_dup(p); 
  }

char* string::str_dup(const char* p)
{ if (p==nil) error_handler(1,"string::str_dup: nil argument");
  char* q = new char[strlen(p)+1];
  strcpy(q,p);
  return q;
}

char* string::str_cat(const char* p1, const char* p2)
{ char* q = new char[strlen(p1)+strlen(p2)+1];
  strcpy(q,p1);
  strcat(q,p2);
  return q;
 }

char* string::str_cat(int argc, char** argv)
{ char* q;
  int l=0;
  for(int i=0;i<argc;i++)  l += (strlen(argv[i])+1); 
  q = new char[l+1];
  q[0] = 0;
  for(i=0;i<argc;i++)
  { strcat(q," ");
    strcat(q,argv[i]);
   }
  return q;
 }

void string::read(istream& s, char delim)
{ char buf[512];
  char* p = buf;
  char* q = p+511;

  while (s.get(*p) && p < q)
  { if (*p == delim) break;
    p++;
   } 
  *p = '\0';

  operator=(buf);
}

#if !defined(sparc) || defined(__GNUG__)
string::string(format_string format,...)
#else
string::string(const char* format,...)
#endif
{ char    buf[512];
  va_list arg_list;
  Va_Start(arg_list,format);
#if !defined(sparc) || defined(__GNUG__)
  vsprintf(buf,format.str,arg_list);
#else
  vsprintf(buf,format,arg_list);
#endif
  va_end(arg_list);
  PTR = new string_rep(buf);
}


int  compare(const string& x, const string& y) 
{ return strcmp(x.cstring(),y.cstring()); }


int   string::length()     const   
{ return strlen(cstring()); }

char string::operator[](int i) const
{ if (i<0 || strlen(cstring())<=i) 
    error_handler(1,"string[]: index out of range");
  return ptr()->s[i];
}

char& string::operator[](int i)
{ if (i<0 || strlen(cstring())<=i) 
    error_handler(1,"string[]: index out of range");
  *this = cstring();    //disconnect
  return ptr()->s[i];
}


string  string::operator+(const string& x)  const
{ char *p = str_cat(cstring(), x.cstring());
  string res = p;
  delete p;
  return res;
}

string  string::operator+(const char* s1)   const
{ char *p = str_cat(cstring(), s1);
  string res = p;
  delete p;
  return res;
}

string& string::operator+=(const char* s1)  
{ *this = *this + s1; 
  return *this; 
 }

string& string::operator+=(const string& x) 
{ *this = *this + x; 
  return *this; 
 }

//friends

int operator==(const string& x, const char* s)   
{ return strcmp(x.cstring(),s)==0; }

int operator==(const string& x, const string& y) 
{ return strcmp(x.cstring(),y.cstring())==0; }

int operator!=(const string& x, const char* s)   
{ return strcmp(x.cstring(),s)!=0; }

int operator!=(const string& x, const string& y) 
{ return strcmp(x.cstring(),y.cstring())!=0; }

int operator<(const string& x, const string& y)  
{ return strcmp(x.cstring(),y.cstring())<0; }

int operator>(const string& x, const string& y)  
{ return strcmp(x.cstring(),y.cstring())>0; }

int operator<=(const string& x, const string& y) 
{ return strcmp(x.cstring(),y.cstring())<=0; }

int operator>=(const string& x, const string& y) 
{ return strcmp(x.cstring(),y.cstring())>=0; }


/*
istream& operator>>(istream& in, string& x)
{ char buf[256];
  if (in >> buf) x.operator=(buf); 
  return in;
}
*/

istream& operator>>(istream& in, string& x)
{ char buf[256];
  char* p = buf;

  //skip white space but not end of line
  while (in.get(*p) && isspace(*p) && *p != '\n'); 

  if (in && *p != '\n')
  { p++;
    while (in.get(*p) && !isspace(*p)) p++;
   }

  *p = '\0';
  x.operator=(buf);
  return in;
}


ostream& operator<<(ostream& out, const string& x) 
{ return out << x.cstring(); }


string string::sub(int i, int j) const
{
  if (j >= length()) j = length() - 1;

  if (i < 0) i = 0;

  int l = j-i+1;

  if (l <= 0)  return string("");

  char* q = new char[l+1];
  strncpy(q,cstring()+i,l);
  q[l] = '\0';

  string s(q);
  delete q;
  return s;
}

int string::pos(string s1, int i) const
{
  int l1 = s1.length();
  if (l1==0 || i >= length()) return -1;

  char c = s1[0];

  char* q = cstring() + i;
  while (*q)
    { while ( (*q) && (*q != c) ) q++;
      if ( strncmp(q,s1.cstring(),l1)==0 ) break ;
      if (*q) q++;
     }
  return (*q) ? (q - cstring())/ sizeof(char) :  -1;
}

string string::insert(string s, int i) const
{ return sub(0,i-1) + s + sub(i,length()-1); }

string string::insert(int i, string s) const
{ return sub(0,i-1) + s + sub(i,length()-1); }


string string::del(int i, int j) const
{ return sub(0,i-1) + sub(j+1,length()-1); }

string string::del(const string& s, int n) const
{ return replace(s,"",n); }



string string::replace(int i, int j, const string& s) const
{ return sub(0,i-1) + s + sub(j+1,length()-1); }

string string::replace(const string& s1, const string& s2, int n) const 
{ 
  // replace n-th (all if n=0) occurrence of s1 by s2 

  int i = 0;
  int match = 0;  

  int l1 = s1.length();

  string tmp;

  for(;;)
  { int j = pos(s1,i);
    if (j < 0 ) break;
    tmp += sub(i,j-1);

    if (n==0 || ++match == n)
       tmp += s2;
    else
       tmp += s1;

    i = j+l1;
   }

  tmp += sub(i,length()-1);

  return tmp;

 }


string string::format(string f) const
{ 
  char buf[512];
  sprintf(buf,~f,cstring());
  return buf;

 }

