.\" @(#)writeline.3t	1.3 5/15/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFWriteScanline 3T "May 2, 1990"
.SH NAME
TIFFWriteScanline \- write a scanline to an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFWriteScanline(TIFF* tif, u_char* buf, u_int row, u_int sample)"
.SH DESCRIPTION
Write data to a file at the specified row.
The
.I sample
parameter is used only if data are organized in separate planes (\c
.IR PlanarConfiguration =2).
The data are assumed to be uncompressed and in the native
bit- and byte-order of the host machine.
The data written to the file is
compressed according to the compression scheme
of the current
.SM TIFF
directory (see further below).
.IR TIFFWriteScanline
returns \-1 if it immediately detects an error
and 1 for a successful write.
If the current scanline is past the end of the current subfile, the
.I ImageLength
field is automatically increased to include the scanline (except
for
.IR PlanarConfiguration =2,
where the
.I ImageLength
cannot be changed once the first data are written).
If the
.I ImageLength
is increased, the
.I StripOffsets
and
.I StripByteCounts
fields are similarly enlarged to reflect data written past the
previous end of image.
.SH NOTES
The library attempts to hide bit- and byte-ordering differences
between the image and the native machine by converting data
from the native machine order.
Bit reversal is always done if the
.I FillOrder
tag is opposite to the native machine bit order.
Byte swapping of 16- and 32-bit samples is automatically
done when
.IR Compression =1
(``no compression''), but otherwise is left to the
compression algorithms (which should generate compressed
data in the native byte ordering of the machine).
.PP
In C++ the
.I sample
parameter defaults to 0.
Once data are written to a file for the current directory,
the values of certain tags may not be altered; see
.IR TIFFSetField (3T)
for more information.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
.BR "Compression algorithm does not support random access" .
Data was written in a non-sequential order to a file that
uses a compression algorithm and that has
.I RowsPerStrip
greater than one.
That is, data in the image is to be stored in a compressed form,
and with multiple rows packed into a strip.
In this case, the library does not support random access to the data.
The data should either be written sequentially, or the value of
.I RowsPerStrip
should be set to one.
.PP
\fB%s: Must set "ImageWidth" before writing data\fP.
The image's width has not be set before the first write.
See
.IR TIFFSetField (3T)
for information on how to do this.
.PP
\fB%s: Must set "PlanarConfiguration" before writing data\fP.
The organization of data has not be defined before the first write.
See
.IR TIFFSetField (3T)
for information on how to do this.
.PP
\fBCan not change "ImageLength" when using separate planes\fP.
Separate image planes are being used (\c
.IR PlanarConfiguration =2),
but the number of rows has not been specified before the first write.
The library supports the dynamic growth of an image only when data
are organized in a contiguous manner (\c
.IR PlanarConfiguration =1).
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFWriteEncodedStrip (3T),
.IR TIFFWriteRawStrip (3T)
