 /*
  * Khoros: $Id: warpimage.h,v 1.2 1991/10/02 00:20:04 khoros Exp $
  */

 /*
  * $Log: warpimage.h,v $
 * Revision 1.2  1991/10/02  00:20:04  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: warpimage.h
 >>>>            Author: Tom Sauer, Danielle Argiro
 >>>> Date Last Updated: Wed Apr 24 09:10:47 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _warpimage_h_
#define _warpimage_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
#include "xvdisplay.h"
#include "form_info.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    warpimage Argument Structure
*
****************************************************************/

typedef struct _warpimage  {

/*
 *  input source image (Optional infile)
 */
char	*src;     	/* input source image FILENAME */
int	 src_flag;	/* input source image FLAG */

/*
 *  input target image (Optional infile)
 */
char	*target;     	/* input target image FILENAME */
int	 target_flag;	/* input target image FLAG */

/*
 * selection type  (Optional boolean toggle - )
 */
int	 tp_mode;   		/* selection type  LOGICAL TOGGLE */
int	 tp_mode_flag;		/* selection type  FLAG */

}  warpimage_struct;

warpimage_struct *warpimage;

/* -include_additions */
Display *display;

/*
 *  structure holding information about the zoom window
 */
typedef struct
{
        int     id;
        int     mode;
        XImage *ximage;
        Widget  raster;
        float   zoomfactor;
        int     cursor;

        struct  xvimage *assoc_image;
        Widget  assoc_raster;
        XImage  *assoc_ximage;

        int    xpos, ypos;
        int    xoffset, yoffset;

        int    min_x, min_y;
        int    x_zoom_loc, y_zoom_loc;

} ZoomStructure;

DisplayStructure *src_image, *dest_image;
DisplayStructure *map_display;
ZoomStructure    *src_zoom,  *dest_zoom;

typedef struct _TiePointNode
{
        int id;  /* tiepoint identifier */

        int src_x, src_y;   /* (x, y) location of tiept in src image */
        int dest_x, dest_y; /* (x, y) location of tiept in dest image */

        Pixel src_old_pixel[3][3],  /* saved values of pixels in XImage  */
              dest_old_pixel[3][3]; /* before tiept was dropped,         */
                                    /* for restoration of image          */

        Widget tiept_label;         /* backplane of tiept label */
        Widget offset;              /* previous label's backplane for offset */
        Widget src;                 /* text widget for (x,y) location of src */
        Widget dest;                /* text widget for (x,y) location of dest */

        struct _TiePointNode *next;

} TiePointNode;

void redisplay_zoom();
void update_zoom();

xvf_form  *form;
Master     Master_info;

TiePointNode *tiepoints;

GC gc, gc_zoom, gc_set, gc_xor, gc_invert;

Pixel black, white, grey, green, red, background, foreground;

struct xvimage source_image_header;
char *input_source_image;
char *tmpxcoeffs;
char *tmpycoeffs;

Window rootwindow;         /* so we don't have to do XDefaultRootWindow again */
Widget workspace;          /* our backplane for src, dest, and zoom windows */
Widget view_toplevel;      /* our toplevel for view tiepoints widget */
Widget viewback;           /* our backplane for view tiepoints widget */
Widget tiept_label_offset; /* offset for newest tiept label */

Widget create_view_workspace();
Widget add_tiepoint_label();

int point_and_clicking;
int rubberbanding;
int tiepoint_mode;
int tiepoint_started;
int tp_count;

#define RubberBand 1
#define PointClick 2

#define ZoomDisplayWidth  200
#define ZoomDisplayHeight 200
#define DefaultZoomFactor 2.0
#define SrcZoom  1
#define DestZoom 2

#define SourceAndDest 1
#define SourceOnly    2

#define AddTiePoint     1
#define DeleteTiePoint  2

#define SourceImage     1
#define DestinationImage 2


#define check_hot_spot(x, y, hot_x, hot_y) \
        ((((x <= hot_x+1) && (x >= hot_x-1)) && \
          ((y <= hot_y+1) && (y >= hot_y-1))) ? (True) : (False))


void add_src_tiepoint();
void add_dest_tiepoint();
void delete_tiepoint();
void pc_zoom();
void rb_start();
void rb_move();
void rb_end();
void redisplay_zoom();
void redraw_rubberband();

/*
 * Special translation table used for hitting <cr> in the 
 * src and dest tiepoints text widgets in the View Tiepoints widget
 */

static char live_tiepts_trans_table[] =
"<Key>0xff0d:   return_live_tiepts() \n\
Ctrl<Key>x:    beginning-of-file()";

void return_live_tiepts();
static XtActionsRec livetiepts_actionTable[] =
{
  { "return_live_tiepts",  return_live_tiepts},
};
XtTranslations  live_tiepts_trans;



/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
