 /*
  * Khoros: $Id: warpimage.c,v 1.1 1991/05/10 15:59:17 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: warpimage.c,v 1.1 1991/05/10 15:59:17 khoros Exp $";
#endif

 /*
  * $Log: warpimage.c,v $
 * Revision 1.1  1991/05/10  15:59:17  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: warpimage.c
 >>>>
 >>>>      Program Name: warpimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	An interactive image warping application
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer, Danielle Argiro
 >>>>
 >>>> Date Last Updated: Fri Apr 26 14:48:32 1991
 >>>>
 >>>>          Routines: main- the main program for warpimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "warpimage.h"


/****************************************************************
 *
 * Routine Name:  main program for warpimage
 *
 *       Input:  
 *
 *
 *           [-src] input source image
 *           [-target] input target image
 *           [-tp_mode] selection type 
 *		1 (Select Source & Destination),
 *		or 2 (Select Source Only)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *src, *target, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        /* read in source and target images */
        if (warpimage->src_flag)
        {
           if ((src = readimage(warpimage->src)) == NULL) exit(1);
           input_source_image = VStrcpy(warpimage->src);

           if (src->data_storage_type == VFF_TYP_BIT)
           {
              if (! lvconvert(src, VFF_TYP_1_BYTE, 1 ,0 , 255.0, 1.0, 1))
              {
                 fprintf(stderr, 
           "%s: ERROR unable to convert the BIT source image to a BYTE image\n",
                       program);
                 exit(1);
              }
           }
        }
        else src = NULL;

        if (warpimage->target_flag)
        {
           if ((target = readimage(warpimage->target)) == NULL) exit(1);
           if (target->data_storage_type == VFF_TYP_BIT)
           {
              if (! lvconvert(target, VFF_TYP_1_BYTE, 1 , 0, 255.0, 1.0, 1))
              {
                 fprintf(stderr, 
           "%s: ERROR unable to convert the BIT source image to a BYTE image\n",
                    program);
                 exit(1);
              }
           }
        }
        else target = NULL;

/* -main_before_lib_call_end */

/* -main_library_call */
        lwarpimage(src, target, warpimage->tp_mode, argc, argv, program);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for warpimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "warpimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tAn interactive image warping application\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-src]  input source image (infile) [null]\n");
	fprintf(stderr,"\t[-target]  input target image (infile) [null]\n");
	fprintf(stderr, "\t[-tp_mode]  selection type \n");
	fprintf(stderr, "\t\t1  (Select Source & Destination),\n");
	fprintf(stderr, "\t\tor 2  (Select Source Only)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for warpimage\n");
	fprintf(stderr, "\t[-V] Gives the version for warpimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for warpimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called warpimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses warpimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for warpimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*src_pstr = 
	"\nEnter: (src) input source image \n        {infile}: "; 
char	*target_pstr = 
	"\nEnter: (target) input target image \n        {infile}: "; 
char	*tp_mode_pstr = "\nEnter: (tp_mode) selection type  -- \n      \t\t1 (Select Source & Destination)\n\t\tor 2 (Select Source Only)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "warpimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "warpimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "warpimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "warpimage.ans");
		}

	     }

	}

	/*
	 * allocate the warpimage structure
	 */
	warpimage = (warpimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (warpimage_struct));

	/*
	 * get optional arguments for warpimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	warpimage->src_flag = vget_infile(fid, prompt_flag,
	"-src", src_pstr, &(warpimage->src))
;

	warpimage->target_flag = vget_infile(fid, prompt_flag,
	"-target", target_pstr, &(warpimage->target))
;


	/*
	 * get optional toggles for warpimage
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		warpimage->tp_mode_flag = vget_int(fid, prompt_flag,
		"-tp_mode", tp_mode_pstr, &(warpimage->tp_mode),
		1, 0, 0);

		if ((warpimage->tp_mode == 1 ) || 
		     (warpimage->tp_mode == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		warpimage->tp_mode_flag = vget_int(fid, prompt_flag,
		"-tp_mode", tp_mode_pstr, &(warpimage->tp_mode),
		1, 0, 0);

		if ((warpimage->tp_mode!= 1 ) && 
		     (warpimage->tp_mode!= 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



