 /*
  * Khoros: $Id: mkdir.c,v 1.3 1992/03/20 22:52:39 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: mkdir.c,v 1.3 1992/03/20 22:52:39 dkhoros Exp $";
#endif

 /*
  * $Log: mkdir.c,v $
 * Revision 1.3  1992/03/20  22:52:39  dkhoros
 * VirtualPatch5
 *
  */
/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */
#include "kraftsman.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: mkdir.c                                <<<<
   >>>>                                                       <<<<
   >>>>   description: File Utility                           <<<<
   >>>>                                                       <<<<
   >>>>      routines: int vmkdir()                           <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/***********************************************************************
*
*  Routine Name: vmkdir()
*
*          Date: 12/4/91
*
*       Purpose: To create the directory specified by "path" with access
*		 mode specified by "mode".  It calls the system 
*		 routine mkdir().  NOTE: no malloc's are done in
*		 this routine.
*
*         Input: path -- pathname of new directory to create
*		 mode -- octal permission mode of the new directory
*
*        Output: returns 0 on success
*			-1 on fail
*		 NOTE:  Unlike mkdir(), this routine will return 0
*		 if the directory specified by path already exists.
*
*    Written By: Steven Jorgensen
*
* Modifications:
*
***********************************************************************/
int vmkdir(path, mode)
  char *path;
  int mode;
  {
    int rtl;
    char npath[LENGTH];

    if (path == NULL)
      return(-1);

    if ((vfullpath(path,NULL,npath)) == NULL)
      return(-1);

	/*
	 * return code is determined by the success of mkdir() and
	 * whether or not errno indicates that the directory exists already
	 */
    rtl = ((mkdir(npath,mode) == 0) ? 0 : -1);
    return(rtl);
  }
