 /*
  * Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:52:20 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.3 1992/03/20 22:52:20 dkhoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.3  1992/03/20  22:52:20  dkhoros
 * VirtualPatch5
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Sat Mar 14 14:31:36 1992
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_Master
*
*       Purpose: Fills in the user-specified
*                'Master'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'Master'
*
*       Output:  current values stored in  Master
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Master(formptr, forminfo)

xvf_form *formptr;
Master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'Master' Form Information structure *****/


	index = 1;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->Kraftsman_selected = line_info.selected;
	_xvf_get_Kraftsman(formptr, forminfo->Kraftsman);

}

/********************************************************
*
*  Routine Name: xvf_get_Kraftsman
*
*       Purpose: Fills in the user-specified
*                'Master_Kraftsman'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_Kraftsman'
*
*       Output:  current values stored in  'Master_Kraftsman'
*
*    Called By:  xvf_get_*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Kraftsman(formptr, subforminfo)

xvf_form *formptr;
Master_Kraftsman *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 2;


	/*** extracting 'Master->Kraftsman'
 	   Subform Information structure ***/


	index = 5;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->delete = line_info.selected;

	index = 6;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->remove = line_info.selected;

	index = 9;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 11;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->create_selected = line_info.selected;
	_xvf_get_create(formptr, subforminfo->create);

	index = 23;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->configure_selected = line_info.selected;
	_xvf_get_configure(formptr, subforminfo->configure);

}



/********************************************************
*
*  Routine Name: xvf_get_create
*
*       Purpose: Fills in the user-specified
*                'Kraftsman_create'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'Kraftsman_create'
*
*       Output:  current values stored in  'Kraftsman_create'
*
*    Called By:  xvf_get_Kraftsman
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_create(formptr, paneinfo)

xvf_form *formptr;
Kraftsman_create *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 12;


	/* extracting 'Master->Kraftsman->create'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->toolbox = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->toolbox = NULL;

	paneinfo->toolbox_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->toolpath = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->toolpath = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->author = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->author = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->user = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->user = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->title = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->title = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->sdescript = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->sdescript = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->info = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->info = NULL;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->add = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_configure
*
*       Purpose: Fills in the user-specified
*                'Kraftsman_configure'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'Kraftsman_configure'
*
*       Output:  current values stored in  'Kraftsman_configure'
*
*    Called By:  xvf_get_Kraftsman
*

*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_configure(formptr, paneinfo)

xvf_form *formptr;
Kraftsman_configure *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 24;


	/* extracting 'Master->Kraftsman->configure'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->toolbox = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->toolbox = NULL;

	paneinfo->toolbox_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->tselect = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->libdir = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->libdir = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->bindir = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->bindir = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->libpath = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->libpath = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->incpath = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->incpath = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->ccdef = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->ccdef = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->toollib = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->toollib = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->forlib = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->forlib = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->xlib = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->xlib = NULL;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->configure = line_info.selected;
	index++;

	index++;



}


