 /*
  * Khoros: $Id: overlays.c,v 1.2 1992/03/20 22:39:16 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: overlays.c,v 1.2 1992/03/20 22:39:16 dkhoros Exp $";
#endif

 /*
  * $Log: overlays.c,v $
 * Revision 1.2  1992/03/20  22:39:16  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "editimage.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>         	Editimage Overlays		      <<<<
   >>>>                                                       <<<<
   >>>>			change_overlays()		      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/********************************************************
*
*  Routine Name:  change_overlays
*
*       Purpose:  changes the overlay images displayed on the
*		  image widget.
*
*         Input:  none
*
*        Output:  none
*
*     Called By:  run_image()
*
*    Written By:  Mark Young & Danielle Argiro
*
********************************************************/

change_overlays()
{
	struct  xvimage *image;
        char    **overnames, temp[MAXBUF];
        int     i, j, current, band_num, num_entries, multsel;

	char *label  = "Overlay Bands";

	char *prompt  = "Pick Only One Band To Be Overlayed";
	char *prompts = "Pick Bands To Be Overlayed";

	XawListReturnStruct *entry, **entries;


	if (overlays == NULL)
	{
	   xvf_error_wait("No overlay images bands found to be overlayed onto \
the image.  Use either input overlays or the -ov command.", "change_overlays",
			  NULL);
	   return;
	}

	if (overlays->data_storage_type == VFF_TYP_BIT)
	   multsel = True;
	else
	   multsel = False;

	if (num_ovbands > 1)
	{
           overnames = (char **) malloc(sizeof(char *) * (num_ovbands + 2));
           for (i = 0; i < num_ovbands; i++)
           {
	       if (multsel)
	       {
                  if (ovactive[i])
		     (void) sprintf(temp," overlay %1d (displayed)", i);
		  else
                     (void) sprintf(temp," overlay %1d (hidden)", i);
	       }
	       else
                  (void) sprintf(temp," overlay band %1d", i);

               overnames[i] = xvf_strcpy(temp);
           }

	   if (multsel)
	   {
              overnames[num_ovbands] = xvf_strcpy(" Add all overlays ");
              overnames[num_ovbands+1] = xvf_strcpy(" Delete all overlays ");
	   }
	   else
              overnames[num_ovbands] = xvf_strcpy(" Delete current overlay ");

	   /*
	    *  Prompt the user for which overlay they want using a list widget
	    */
	   if (multsel)
	   {
	      entries = xvf_run_list_multsel_wait(overnames, num_ovbands+2, 1,
				prompts, label, False, False, &num_entries);

	      if (entries == NULL)
		 return;

	      for (i = 0; i < num_entries; i++)
	      {
		 current = entries[i]->list_index;
		 if (current < num_ovbands)
		    ovactive[current]=((ovactive[current] == True)?False:True);
		 else if (current == num_ovbands)
		   for (j = 0; j < num_ovbands; j++) ovactive[j] = True;
		 else if (current == num_ovbands+1)
		   for (j = 0; j < num_ovbands; j++) ovactive[j] = False;

	         free(entries[i]);
	      }
	      free(entries);
	   }
	   else
	   {
	      entry = xvf_run_list_wait(overnames, num_ovbands+1, 1, prompt,
				label, NULL, False);
	      if (entry == NULL)
		 return;
	      else if (entry->list_index == num_ovbands)
		 band_num = -1;
	      else
		 band_num = entry->list_index;

	      free(entry);
	   }

	   for (i = 0; i < num_ovbands; i++)
	      free(overnames[i]);

	   free(overnames);
	}
	else
	{
	   multsel = False;
	   if (xvdisplay->overlay == NULL)
	      band_num = 0;
	   else
	      band_num = -1;
	}

	if (multsel)
	{
	   for (i = 0; i < num_ovbands; i++)
	   {
	      if (ovactive[i] == True)
		 break;
	   }

	   if (i == num_ovbands)
	   {
	      if (xvdisplay->overlay != xvdisplay->ovmask)
	         freeimage(xvdisplay->ovmask);

	      xvdisplay->ovmask  =
	      xvdisplay->overlay = NULL;
	      xvd_update_overlay(xvdisplay, NULL);
	   }
	   else if (lvlayer(overlays, &image, ovactive))
	   {
	      xvd_update_overlay(xvdisplay, image);
	   }
	   else
	   {
	      xvf_error_wait("Failed to build the overlay image from the \
multi-band bit overlay image.  In order to show an overlay image a single \
byte image must be contructed which is overlayed on top of the display image. \
Please try again with a different overlay image.", "build_overlays", NULL);
	     return;
	   }
	}
	else
	{
	   if (band_num == -1)
	      xvdisplay->overlay = NULL;
	   else
	      xvdisplay->overlay = ovband[band_num];

	   xvd_update_overlay(xvdisplay, NULL);
	}
}
