 /*
  * Khoros: $Id: leditimage.c,v 1.4 1992/03/20 22:39:07 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: leditimage.c,v 1.4 1992/03/20 22:39:07 dkhoros Exp $";
#endif

 /*
  * $Log: leditimage.c,v $
 * Revision 1.4  1992/03/20  22:39:07  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: leditimage.c
 >>>>
 >>>>      Program Name: editimage
 >>>>
 >>>> Date Last Updated: Sat Mar  7 14:00:53 1992 
 >>>>
 >>>>          Routines: leditimage - the library call for editimage
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "editimage.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: leditimage - library call for editimage
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Mark Young, Stephanie Hallett, Danielle Argiro
****************************************************************/


/* -library_def */
int leditimage(argv, argc, program, img_infile, ov_infile, shape_infile, 
               clip_infile, roi_outfile, zoomfactor, update,
               display_name, alt_form, use_cmap, cmap_infile, xpos, ypos)
int      argc;
char    *argv[], *program;
char    *img_infile, *ov_infile, 
        *shape_infile, *clip_infile, 
        *roi_outfile;
float    zoomfactor, update;
char    *display_name, *alt_form;
int      use_cmap;
char    *cmap_infile;
int      xpos, ypos;

/* -library_def_end */

/* -library_code */
{
        char *form_filestring;
        char *form_pathname, temp[MAXBUF];

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        if (display_name != NULL)
        {
           (void) sprintf(temp, "DISPLAY=%s", display_name);
           vputenv(xvf_strcpy(temp));
        }

        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         *  perform global initializations for this application
         */
        xvd_initialize(display);


        /*
         *  initialize global xvdisplay structure
         */
        if (!(init_image(img_infile, shape_infile, clip_infile, ov_infile,
                   cmap_infile, use_cmap))) return(false);

        xvf_set_visual(xvdisplay->visual);
        xvf_set_colormap(xvdisplay->colormap);

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        if (alt_form != NULL)
           form_filestring = xvf_strcpy(alt_form);
        else form_filestring = xvf_strcpy("editimage.form");

        /* form_pathname   = xvf_strcpy("./"); */
        form_pathname   = xvf_strcpy("KHOROS_HOME/repos/editimage"); 
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, 
                                     SIMPLE, NULL, xpos, ypos)))
           return(false);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_edit(form,  &edit_info);

        if (roi_outfile != NULL)
	{
           xvf_change_input(form, edit_info.roi_subform->roi->extract_index,
                            xvf_outputfile_chng, roi_outfile, 0);
           xvf_change_input(form, edit_info.files_subform->file->outfile_index,
                            xvf_outputfile_chng, roi_outfile, 0);
	}

        /*
         *  initialize global xvdisplay structure
         */
        if (xvd_build_xvdisplay(xvdisplay) == False)
           return(False);

        /*
         *  Add detect code to update when the image updates.
         */
        update_time = update;
        if (update != 0.0)
           update_id = xvf_detect_file(img_infile, update, update_file, NULL);
        else
           update_id = 0;

        image_workspace = edit_info.image_workspace;

        /*
         *  create & initialize the display widgets
         *  for the raster, pseudo, lut, threshold, zoom, and pixels displays
         */
        create_raster_display(form, image_workspace);
        create_zoom_display(edit_info.zoom_subform->zoom->zoom_workspace, 
                            zoomfactor);
        create_pseudo_display(edit_info.pseudo_subform->pseudo->pseudo_workspace);
        create_pixel_display(edit_info.pixels_subform->pixels->pixels_workspace);
        create_lut_display(edit_info.lut_subform->lut->lut_workspace);

        create_thres_display(edit_info.thres_subform->thres->thres_workspace);

        /*
         *  Set the new colormap for each of the display structures.
         *  Then call the update threshold routine "update_thres" to
         *  set the current threshold, then refresh all the visible
         *  displays
         */
        init_gc(image_workspace);
        init_annontation(xvdisplay->raster);

        set_colormap();
        update_thres();
        refresh_displays(0, MAX_PIXELS);

        /*
         * Map the forms
         */
        xvf_change_active(form, true);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_edit(form, &edit_info);

             if (edit_info.change_bands)
             {
                  change_image_bands(); 
             }

             if (edit_info.overlay_image)
             {
                change_overlays();
             }

             if (edit_info.info)
             {
                image_info();
             }

             if ((edit_info.combine_overlays) || 
                 (edit_info.combine_annotations))
             {
                xvf_map_widget(edit_info.image_workspace);
                combine_overlays();
             }

             /*
              * action came from the 'zoom' subform
              */
             if (edit_info.zoom_subform_selected)
             {
                  if (edit_info.zoom_subform->zoom_selected)
                      run_zoom(form, edit_info.zoom_subform->zoom);
             }
             /*
              * action came from the 'pixels' subform
              */
             if (edit_info.pixels_subform_selected)
             {
                  if (edit_info.pixels_subform->pixels_selected)
                     run_pixels(form, edit_info.pixels_subform->pixels);
             }
             /*
              * action came from the 'lut' subform
              */
             if (edit_info.lut_subform_selected)
             {
                  if (edit_info.lut_subform->lut_selected)
                     run_lut(form, edit_info.lut_subform->lut);
             }

             /*
              * action came from the 'pseudo' subform
              */
             if (edit_info.pseudo_subform_selected)
             {
                  if (edit_info.pseudo_subform->pseudo_selected)
                      run_pseudo(form, edit_info.pseudo_subform->pseudo);
             }

             /*
              * action came from the 'thres' subform
              */
             if (edit_info.thres_subform_selected)
             {
                  if (edit_info.thres_subform->thres_selected)
                      run_thres(form, edit_info.thres_subform->thres);
             }

             /*
              * action came from the 'files' subform
              */
             if (edit_info.files_subform_selected)
             {
                  if (edit_info.files_subform->file_selected)
                      run_file(form, edit_info.files_subform->file);
             }

             /*
              * action came from the 'roi' subform
              */
             if (edit_info.roi_subform_selected)
             {
                  if (edit_info.roi_subform->roi_selected)
                      run_roi(form, edit_info.roi_subform->roi);
             }

             /*
              * action came from the 'colormap' subform
              */
             if (edit_info.colormap_subform_selected)
             {
                  if (edit_info.colormap_subform->colormap_selected)
                      run_colormap(form, edit_info.colormap_subform->colormap);
             }

             /*
              * action came from the 'comment' subform
              */
             if (edit_info.comment_subform_selected)
             {
                  if (edit_info.comment_subform->comment_selected)
                      run_comment(form, edit_info.comment_subform->comment);
             }

             /*
              * action came from the 'xvoverlay' subform
              */
             if (edit_info.xvoverlay_selected)
             {
                  run_xvoverlay(form, edit_info.xvoverlay, 
                                xvdisplay->raster);
             }

             xvf_clear_selections(form->db, form->line_num);

        } while (!edit_info.quit);    /* end user interface loop */

        if (xvdisplay != NULL)
        {
           free_images();
           free_overlays();
           xvd_delete_image(xvdisplay);
        }
        XSync(display, 0); XCloseDisplay(display);
        return(true);
}


/* -library_code_end */
