 /*
  * Khoros: $Id: cnd_incl.c,v 1.4 1992/03/20 22:45:13 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cnd_incl.c,v 1.4 1992/03/20 22:45:13 dkhoros Exp $";
#endif

 /*
  * $Log: cnd_incl.c,v $
 * Revision 1.4  1992/03/20  22:45:13  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "conductor.h"

/************************************************************
*
*  Routine Name: cnd_gen_form_struct
*
*      Purpose:  
*	This routine takes the database, and from the information
*	in the database, creates a file in the local directory 
*	called "forminfo.h".  Inside "forminfo.h" is the application-to
*	xvform information structure that xvforms use to pass back 
*	information to the application program that uses xvforms.  
*	This structure will have one sub-structure for each of its
*	subordinate subforms specified in the database. 
*	Each subform structure will have one substructure for each pane 
*	specified in the database.
*		 
*        Input:  database - the internal database
*
*       Output:  the "form_info.h" file to be used by the application program
*		 returns TRUE if the structures were created successfully,
*			 FALSE otherwise
*
*   Written By:  Danielle Argiro 
*
*************************************************************/

int cnd_gen_form_struct(database)

char **database;
{

	char    *form_var, *subform_var[50], *fullpath;
	FILE 	*fid, *tmpfile;
	int  	j, flag, index;
	int     master_action_count = 0, subform_count = 0, work_count = 0;
	int     master_form_quit_flag = 0, master_form = 0;
	int     cnd_gen_subform_struct();
	Line_Info line_info;
	char    *master_action[25], *work_widgets[25], resp, temp[512];
	time_t  clock;


	static 
	char *hdr = "typedef struct { ",
	     *blanks   = "        ";


        /*
	 *  first of all, if 'form_info.h' exists, see if they want to over-
	 *  write it.  If not, return immediately.
	 */
        fullpath = vfullpath("form_info.h", NULL, NULL);
        if (!conductor->f)
        {
           if (tmpfile = fopen(fullpath, "r"))
           {
              fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", fullpath);
              fgets(temp, MaxLength, stdin);
              sscanf(temp, "%c", &resp);
              if ((resp != 'y') && (resp != 'Y')) 
	          return(true);
           }
        }

	/* 
	 * create & open the "form_info.h" file which will have the 
	 * "form_info" structure definitions 
	 */
	if ((fid = fopen("form_info.h", "w"))== NULL)
	{
		fprintf(stderr, "\ncnd_gen_form_struct:\n");
		fprintf(stderr, "Could not create file 'form_info.h'\n");
		return(false);
	}

	/* begin file with RCS header */
	fprintf(fid, " /*\n  * Khoros: %cId%c\n  */\n\n", '$', '$');
        fprintf(fid, " /*\n  * %cLog%c\n  */\n\n", '$', '$');

	/* follow RCS header with UNM copyright */
        fprintf(fid, "%s", cp_top); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s", cp_right); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s\n", cp_bottom); 

		
	/* write the header into the "form_info.h" file */
	fprintf(fid, "%s", filehdr_top);
        fprintf(fid, " >>>>\n");
	fprintf(fid, "%s form_info.h\n", filehdr_file);
        fprintf(fid, " >>>>\n");
	fprintf(fid, "%s structure in which values extracted\n", filehdr_desc);
        fprintf(fid, " >>>>                      from the graphical user interface are stored\n");
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s automatically generated by conductor\n", filehdr_auth);
        fprintf(fid, " >>>>\n");

        clock = (time_t) time(NULL);
        sprintf(temp, "%s %s\n", filehdr_date, ctime(&clock));
	temp[xvf_strlen(temp)-2] = '\0';
        fprintf(fid, "%s\n", temp);
        fprintf(fid, " >>>>\n");
	fprintf(fid, "%s", filehdr_bottom);
	
	/* make sure it starts with a StartForm definition */
	index = 0;
 	flag = xvf_get_line_type(database[index]);
	if (flag != StartForm)
	{
		fprintf(stderr, "\ncnd_gen_form_struct:\n");
		fprintf(stderr, "  First line in specified database\n");
		fprintf(stderr, "must be a StartForm (-F) line\n");
		fprintf(stderr, " - aborting creation of 'form_info.h'\n");
		return(false);
	}

	/* read the StartForm definition & get FormInfo variable name */

	xvf_clear_line_info(&line_info);
	xvf_parse_startform_line(database[index], &line_info);
	if (line_info.variable == NULL)
	{
		fprintf(stderr, "\ncnd_gen_form_struct:\n");
		fprintf(stderr, "Form does not have a variable name \n");
		fprintf(stderr, "associated with it. Cannot generate the \n");
		fprintf(stderr, "FormInfo structure without this string\n");
		fprintf(stderr, "to indicate what your FormInfo structure \n");
		fprintf(stderr, "should be called!\n");
		return(false);
	}
	form_var = xvf_strcpy(line_info.variable);
	index++;

	    
	do
	{
 	      	flag = xvf_get_line_type(database[index]);

		 switch(flag)
		 {
		    case StartMaster:
		         index++;
			 master_form = true;
			 break;

		    case SubFormButton:
		    case PsuedoSubForm:
		    case StartSubMenu:
		    case HelpSel:
		    case Blank:
		         index++;
			 break;

		    case MasterAction:
		         xvf_parse_master_action_line(database[index], &line_info);
                         if (line_info.variable == NULL)
                         {
                             fprintf(stderr, "\ncnd_gen_form_struct:\n");
                             fprintf(stderr, "Master Action line\n");
                             fprintf(stderr, "  '%s' does not have a variable \n",
               				     database[index]);
                             fprintf(stderr, "associated with it. Cannot ");
                             fprintf(stderr, "generate the proper structure\n");
                             fprintf(stderr, "without this string to indicate \n");
                             fprintf(stderr, "what your variable should be!  \n");
                             return(false);
                         }
                         master_action[master_action_count] = xvf_strcpy(line_info.variable);
                         master_action_count++;
		         index++;
			 break;

		    case WorkWidget:
		         xvf_parse_workspace_line(database[index], &line_info);
                         if (line_info.variable == NULL)
                         {
                             fprintf(stderr, "\ncnd_gen_form_struct:\n");
                             fprintf(stderr, "Master Action line\n");
                             fprintf(stderr, "  '%s' does not have a variable \n",
               				     database[index]);
                             fprintf(stderr, "associated with it. Cannot ");
                             fprintf(stderr, "generate the proper structure\n");
                             fprintf(stderr, "without this string to indicate \n");
                             fprintf(stderr, "what your variable should be!  \n");
                             return(false);
                         }
                         work_widgets[work_count] = 
				xvf_strcpy(line_info.variable);
                         work_count++;
		         index++;
			 break;

		    case QuitForm:
		         master_form_quit_flag = true;
		         index++;
			 break;

		    case End:
			 if (master_form == TRUE) /* skip over it */
			 {
		             index++;
 	                     flag = xvf_get_line_type(database[index]);
			 }
			 break;


		   case StartSubForm:
			xvf_parse_startsubform_line(database[index], &line_info);
			if (line_info.variable == NULL)
			{
	    		    fprintf(stderr,"\ncnd_gen_form_struct:\n");
	        	    fprintf(stderr,"  SubForm line '%s' does not \n",
					    database[index]);
			    fprintf(stderr," have a variable name associated ");
	    	    	    fprintf(stderr, "with it. Cannot generate the \n");
	    	   	    fprintf(stderr, "FormInfo structure without it");
	    		    fprintf(stderr, "to indicate what your Subforminfo\n");
	    		    fprintf(stderr, "structure should be called!\n");
	    		    return(false);
		       }
		       if (strcmp(line_info.variable, form_var) == 0)
		       {
		 	  fprintf(stderr, "conductor:\n");
			  fprintf(stderr, "Cannot generate code properly ");
			  fprintf(stderr, "when a StartSubForm (-M) line\n");
			  fprintf(stderr, "has the same variable name as ");
			  fprintf(stderr, "the StartForm (-F) line.\n");
			  fprintf(stderr, "Please re-examine your naming ");
			  fprintf(stderr, "conventions and try again.\n");
			  return(false);
		       }

		       subform_var[subform_count] = xvf_strcpy(line_info.variable);

		       index++;
		       if (!(cnd_gen_subform_struct(fid, database, &index, 
					            form_var,
						    subform_var[subform_count])))
			    return(false);

	               flag = xvf_get_line_type(database[index]);  
		       subform_count++;
		       break;

		   default:
			fprintf(stderr, "\ncnd_gen_form_struct:\n");
			fprintf(stderr, "database line '%s' ", database[index]);
			fprintf(stderr, "out of place / unknown\n");
			return(false);
			break;

	          } /* end switch */ 

	}  while (flag != End); /* end do-while */


	fprintf(fid, "\n\n%s\n\n", hdr);

	/* declare any 'master-action_selected' variables */
        for (j = 0; j < master_action_count; j++)
                 fprintf(fid, "%sint %s;\n\n", blanks, master_action[j]);

	/* declare any workspace widget variables */
        for (j = 0; j < work_count; j++)
	{
                 fprintf(fid, "%sint %s_index;\n\n", blanks, work_widgets[j]);
                 fprintf(fid, "%sWidget %s;\n\n", blanks, work_widgets[j]);
	}

	/* declare all pairs of 'subform-selected' variables */

        for (j = 0; j <  subform_count; j++)
        {
    	        fprintf(fid, "%s%s_%s  *%s;\n", blanks, form_var,
                           subform_var[j], subform_var[j]);
                fprintf(fid, "%sint %s_selected;\n", blanks, 
					         subform_var[j]);
                fprintf(fid, "%sint %s_index;\n", blanks,
                               			      subform_var[j]);
                fprintf(fid, "%sint %s_sfb_index;\n\n", blanks,
                               				   subform_var[j]);
        }

	if (master_form_quit_flag == true)
                fprintf(fid, "%sint quit;\n\n", blanks);

	fprintf(fid, "\n }  %s; \n\n", form_var);

	fclose(fid);

        fprintf(stderr, "\n cnd_gen_form_struct:\n");
        fprintf(stderr,"Done with generating forminfo structure:\n"); 
        fprintf(stderr,"form information structure in 'form_info.h' \n"); 
	return(true);

} /* end cnd_gen_form_struct */



/************************************************************
*
*  Routine Name: cnd_gen_subform_struct
*
*      Purpose:  generates the structures needed for each subform
*
*        Input:  fid         - open stream to "form_init.h" file
*                database    - the internal database struct
*                index       - current index into the database
*                form_var    - name of the form variable
*                subform_var - name of the subform variable
*
*	 Output: appropriate subform info structures in "form_info.h"
*
*   Called  By:  cnd_gen_form_struct()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

int cnd_gen_subform_struct(fid, database, index, form_var, subform_var)

FILE *fid;
char **database;
int  *index;
char *form_var;
char *subform_var;
{
	Line_Info line_info;
	int	  flag, panecount = 0;
	int  	  j, guide_pane_quit_flag = 0;
	int       subform_action_count = 0, work_count = 0, guide_pane = 0;
	char	  *pane_var[50];
	static char *blanks   = "        ";
	char    *subform_action[25], *work_widgets[25];

	xvf_clear_line_info(&line_info);

	do
	{
	    flag = xvf_get_line_type(database[*index]);  

	    switch (flag)
	    {

		case StartGuide:
		     (*index)++;
		     guide_pane = true;
		     break;

		case GuideButton:
		case Blank:
	  	case HelpSel:
		     (*index)++;
		     break;
	    
	        case SubformAction:
	             xvf_parse_subform_action_line(database[*index], &line_info);
	             if (line_info.variable == NULL)
       	             {
               	         fprintf(stderr, "\ncnd_gen_subform_struct:\n");
               	    	 fprintf(stderr, "Subform Action line\n");
               	         fprintf(stderr, "  '%s' does not have a variable \n",
                                   	database[*index]);
		         fprintf(stderr, "associated with it. Cannot gen\n");
		         fprintf(stderr, "'subform action' variable \n");
	                 fprintf(stderr, "without string to indicate what \n");
		         fprintf(stderr, "your variable should be called! \n");
		         return(false);
    	             }
	             subform_action[subform_action_count] = xvf_strcpy(line_info.variable);
	             subform_action_count++;
		     (*index)++;
		     break;

	        case WorkWidget:
	             xvf_parse_workspace_line(database[*index], &line_info);
	             if (line_info.variable == NULL)
       	             {
               	         fprintf(stderr, "\ncnd_gen_subform_struct:\n");
               	    	 fprintf(stderr, "Workspace line\n");
               	         fprintf(stderr, "  '%s' does not have a variable \n",
                                   	database[*index]);
		         fprintf(stderr, "associated with it. Cannot gen\n");
		         fprintf(stderr, "'subform action' variable \n");
	                 fprintf(stderr, "without string to indicate what \n");
		         fprintf(stderr, "your variable should be called! \n");
		         return(false);
    	             }
	             work_widgets[work_count] = xvf_strcpy(line_info.variable);
	             work_count++;
		     (*index)++;
		     break;

	   	case QuitForm:
	             guide_pane_quit_flag = true;
		     (*index)++;
		     break;

		case End:
		     if (guide_pane == TRUE) /* skip over it */
                     {
                         (*index)++;
                         flag = xvf_get_line_type(database[*index]);
                     }
                     break;

		case StartPane:
	             panecount++;
	             xvf_parse_startpane_line(database[*index], &line_info);

	             if (line_info.variable == NULL)
	             {
    	                 fprintf(stderr, "\ncnd_gen_subform_struct:\n");
    	                 fprintf(stderr, "  Pane %d of does not have \n", panecount);
    	                 fprintf(stderr, "a variable name associated with it.\n");
    	                 fprintf(stderr, " Cannot generate the correct Pane \n");
    	                 fprintf(stderr, "structure without this string\n");
    	                 fprintf(stderr, "to indicate what your Pane structure \n");
    	                 fprintf(stderr, "should be called!\n");
    	                 return(false);
       	            }
		    if (strcmp(line_info.variable, subform_var) == 0)
		    {
			fprintf(stderr, "conductor:\n");
			fprintf(stderr, "Cannot generate driver properly ");
			fprintf(stderr, "when any StartPane (-P) line\n");
			fprintf(stderr, "has the same variable name as a ");
			fprintf(stderr, "the StartSubForm (-M) line.\n");
			fprintf(stderr, "Please re-examine your naming ");
			fprintf(stderr, "conventions and try again.\n");
			return(false);
		    }
	            pane_var[panecount] = xvf_strcpy(line_info.variable);
	            fprintf(fid, "\n\ntypedef struct {\n\n");
	            (*index)++;
	            cnd_gen_pane_struct(fid, database, index);
	            fprintf(fid, "} %s_%s;\n\n", subform_var, 
						   pane_var[panecount]);
	            flag = xvf_get_line_type(database[*index]);  
		    break;

	 	default:
		    fprintf(stderr, "\ncnd_gen_subform_struct:\n");
                    fprintf(stderr, "database line '%s' ", database[*index]);
                    fprintf(stderr, "out of place / unknown\n");
                    return(false);
                    break;

           } /* end switch */

	 } while (flag != End);
         (*index) ++;



	 /* 
	  * put in the main structure that has the subordinate pane 
	  * sub-structures 
	  */
	 
	 /* print the first line of the SubFormInfo definition */
	 fprintf(fid, "typedef struct {\n\n");


	 /* declare any 'subform-action_selected' variables */
	 for (j = 0; j < subform_action_count; j++)
	    fprintf(fid, "%sint %s;\n\n", blanks, subform_action[j]);

	 /* declare any workspace widget variables */
	 for (j = 0; j < work_count; j++)
	 {
	    fprintf(fid, "%sWidget %s;\n\n", blanks, work_widgets[j]);
	    fprintf(fid, "%sint %s_index;\n\n", blanks, work_widgets[j]);
	 }

	 /* declare all pairs of 'pane-selected' variables & pane structs */
	 for (j = 1; j <= panecount; j++) 
	 {
	      fprintf(fid, "%s%s_%s  *%s;\n", blanks, subform_var, 
		 	pane_var[j], pane_var[j]);
	      fprintf(fid, "%sint %s_selected;\n", blanks, pane_var[j]);
	      fprintf(fid, "%sint %s_index;\n", blanks, 
			       pane_var[j]);
	      fprintf(fid, "%sint %s_gb_index;\n\n", blanks, 
			       pane_var[j]);
         }

	 if (guide_pane_quit_flag == true)
	     fprintf(fid, "%sint quit;\n\n", blanks);

	 fprintf(fid, "}  %s_%s;\n", form_var, subform_var);


	 return(true);
}



/************************************************************
*
*  Routine Name: cnd_gen_pane_struct
*
*      Purpose:  generates the structures needed for each pane
*
*        Input:  fid         - open stream to "form_init.h" file
*                database    - the internal database struct
*                index       - current index into the database
*                form_var    - name of the form variable
*                subform_var - name of the subform variable
*
*	 Output: appropriate pane info structures in "form_info.h"
*
*   Called  By:  cnd_gen_subform_struct()
*
*   Written By:  Danielle Argiro
*
*************************************************************/



int cnd_gen_pane_struct(fid, database, index)

FILE *fid;
char **database;
int  *index;
{
	Line_Info line_info;
	int	  flag, mutual_exclusion = false;
	static 
	char *hdr = "typedef struct { ",
	     *begin = " { ",
	     *end = " } ",
	     *hdr2 = "typedef struct ",
	     *blanks   = "        ";

	        
	xvf_clear_line_info(&line_info);
	do 
	{
	      flag = xvf_get_line_type(database[*index]);

	      
	      switch (flag) {

	      case InputFile:
		    xvf_parse_input_line(database[*index], &line_info);
		    fprintf(fid, "%schar *%s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true) || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;

	       case OutputFile:
		    xvf_parse_output_line(database[*index], &line_info);
		    fprintf(fid, "%schar *%s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true) || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;

	       case StringOpt:
		    xvf_parse_string_line(database[*index], &line_info);
		    fprintf(fid, "%schar *%s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true)  || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;

	       case IntegerOpt:
		    xvf_parse_int_line(database[*index], &line_info);
		    fprintf(fid, "%sint %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true) || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;

	      case MutExcl:
		   mutual_exclusion = true;
		   (*index)++;
		   break;

	       case Toggle:
		    xvf_parse_toggle_line(database[*index], &line_info);
		    fprintf(fid, "%sint %s_val;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true) || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    while (flag != End)
                               {
                                  (*index)++;
                                  flag = xvf_get_line_type(database[*index]);
                               }
                           (*index)++;
                           flag = xvf_get_line_type(database[*index]);
   
		    break;

	       case LogicOpt:
		    xvf_parse_logic_line(database[*index], &line_info);
		    fprintf(fid, "%sint %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true)  || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;
	      
	       case Cycle:
		    xvf_parse_cycle_line(database[*index], &line_info);
		    fprintf(fid, "%sint %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true)  || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;
	      
	       case List:
		    xvf_parse_list_line(database[*index], &line_info);
		    fprintf(fid, "%schar *%s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true)  || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;
	      
	      case FloatOpt:
		    xvf_parse_float_line(database[*index], &line_info);
		    fprintf(fid, "%sfloat %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    if ((line_info.live == true)  || (line_info.optional == true))
			fprintf(fid, "%sint %s_selected;\n\n",
                                  blanks, line_info.variable);
		    else fprintf(fid, "\n");
		    (*index)++;
		    break;
	       
	     case Routine:
		    (*index)++;
		    break;

	     case PaneAction:
		    xvf_parse_pane_action_line(database[*index], &line_info);
		    fprintf(fid, "%sint %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n\n", 
				  blanks, line_info.variable);
		    (*index)++;
		    break;

	      case WorkWidget:
		    xvf_parse_workspace_line(database[*index], &line_info);
		    fprintf(fid, "%sWidget %s;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "%sint %s_index;\n", 
				  blanks, line_info.variable);
		    fprintf(fid, "\n");
		    (*index)++;
		    break;

	     case QuitForm:
		    xvf_parse_quit_line(database[*index], &line_info);
		    fprintf(fid, "%sint quit;\n\n", blanks);
		    (*index)++;
		    break;

	     case HelpSel:
	     case Blank:
	     case LibCall:
	     case AnswerInfile:
	     case AnswerOutfile:
		    (*index)++;
		    break;

	     case End:
		   if (mutual_exclusion == true)
		   { 
		      mutual_exclusion = false;
		      (*index)++;
		      flag = xvf_get_line_type(database[*index]);
		   }
       		   break;

	     default:
		   fprintf(stderr, "\n cnd_gen_forminfo:\n");
		   fprintf(stderr, "Unexpected flag within Pane def-\n");
		   fprintf(stderr, "  *index number %d\n", *index);
		   fprintf(stderr, "  line is '%s'\n", database[*index]);
		   fprintf(stderr, "  ignoring line.\n");
		   (*index)++;
		   break;

	     }  /* end switch */

	}  while (flag != End);   /* end do-while */
	(*index)++;

	return(true);

}  /* end cnd_gen_pane_struct */


