 /*
  * Khoros: $Id: structs.h,v 1.4 1992/03/20 22:43:59 dkhoros Exp $
  */

 /*
  * $Log: structs.h,v $
 * Revision 1.4  1992/03/20  22:43:59  dkhoros
 * VirtualPatch5
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: structs.h                              <<<<
   >>>>                                                       <<<<
   >>>>   description: Describes the different structures     <<<<
   >>>>		       used by cantata.			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



#ifndef _structs_h_
#define _structs_h_

/*
 *  declarations and structure definitions for
 *  workspace, glyph, and connection defintion.
 */
typedef struct _glyphlist
{
   struct _glyph     *glyph;
   struct _glyphlist *next;
} GlyphList;

typedef struct _nodelist
{
   struct _node     *node;
   struct _nodelist *next;
} NodeList;

/*
 *  Structure connecting an input or output node specifications
 */
typedef struct _node {
	Boolean	 selected;
	Boolean	 dav;
	Boolean	 temp_file;
	char	 *filename, *restore_name, *transport;
	struct	 _glyph	  *glyph;
	NodeList *links;


	Widget	      widget, dav_widget;
	xvf_selection *selection;
	Position      x, y;
} Node;


/*
 *  Structure machine information used in describing
 */
typedef struct _machine_info
{
 	int	active;
        char    *name;
        char    *hostname;
        char    *hosttype;
        int     machtype;
        Pixmap  machine_icon;
 
        struct  _machine_info *next;
} MachineInfo;
 


/*
 *  Glyph structure containing the different types of glyphs to
 *  found on the screen.  The types of glyphs and their associated
 *  structures:
 *		GLYPH	- Represented as a subform.  This is the basic
 *			  type of glyph which usually represents a process.
 *		PROCEDURE - Represented as a workspace (as a set of subforms or
 *			  glyphs).
 *		CONTROL - Represented as a subform (a set of different
 *			  control operations such as "for" "if").
 *		IMAGE   - Represented as a list of images for image
 *			  sequencing.
 *		COMMENT - Represented as a subform.  This is just a glyph
 *			  which should just be used by the user as a way
 *			  commenting the workspace.
 *		COMMAND - the command glyph allows the user to execute a generic
 *			  command using an optional input or output.
 */

typedef struct _glyph {
	XtEnum type;
	union				/* Associated information for the */
	{				/* different glyph types	  */

	   xvf_sub_form *subform;	/* subform describing the process */
	   struct _workspace *macro;    /* workspace id of the macro	  */
	   char		*imagelist;	/* list of image filenames	  */
	} val;

	XtEnum run_type;
	Position  xpos, ypos;
	Dimension width, height;
	struct	 _workspace *workspace;	/* workspace that this glyph */
					/* belongs to		     */

	/*
	 *  Modified field and widget.  These fields are used to indicate if
	 *  a glyph has been modified and should be run by the autorun
	 *  scheduler.  The modified widget is used to visually indicate
	 *  to the user that the glyph has been modified.  The back widget
	 *  used to show if a glyph has been modified.  This is done by setting
	 *  a stippled pattern on the backplane when modified and none when
	 *  not modified.
	 */
	Boolean	modified;

	/*
	 *  Associated widgets used to make up the glyph.
	 */
	Widget   destroy;
	Widget   form;
	Widget   run;
	Widget   stop;
	Widget   error;
	Widget   reset;
	Widget   toplevel;
	Widget   back;
	Widget   label;
	Widget   remote;

	/*
	 *  The process id if the glyph is running and the name of the
	 *  glyph.
	 */
	int	 pid;
	XtEnum   exec_type;
	Boolean	 managed, demand_scheduled;

	char     *label_str;
	char	 *errorfile;
	char     *toplevel_name, *restore_name, *glyph_name;

	/*
	 *  Machine information describing where a glyph is to be
	 *  executed.  If this points to NULL then the glyph will
	 *  be executed locally.  This can be over-ridden by the
	 *  workspace's remote execution variable.
	 */
	MachineInfo *machine;

	/*
	 *  Input and Output node list.  These lists are used to describe
	 *  how each glyph is connected to other glyphs.
	 */
	NodeList  *input_list, *output_list;
	Node	  *input;

} Glyph;

/*
 *  Widget structure for workspace widget.  This contains a top level shell,
 *  a back form widget, and a simple drawing widget.
 */
typedef struct _workspace
{
	xvf_form   *menuform;	  /*  Workspace menu form		 */
	xvf_form   *glyphform;	  /*  Form containing the glyph subforms */
	GlyphList  *glyphs;	  /*  List of glyphs to be found on the  */
				  /*  workspace.			 */
	GlyphList  *frontlist;    /*  The frontier list used by autorun  */
				  /*  to see what glyph's to execute     */
	GlyphList  *running;	  /*  List of currently running glyphs   */
				  /*  that aren't SINKS or PARSERRUN     */
				  /*  to see what glyph's to execute     */
	GlyphList  *dispatched;	  /*  List of glyphs that have been dis- */
				  /*  patched.  This is used to make     */
				  /*  sure that implied loops cannot     */
				  /*  occurr.				 */
	GlyphList  *selected;     /*  The selection list used to copy    */
				  /*  raise, lower, etc glyphs		 */
				  /*  to see what glyph's to execute     */
	Glyph	   *parent;	  /*  The parent glyph that represents   */
				  /*  this workspace.  NULL if toplevel  */

	Widget	toplevel;	  /*  Toplevel workspace window		 */
	Widget	back;		  /*  Back widget for toplevel		 */
	Widget	name;		  /*  Workspace label name		 */
	Widget  clipboard;	  /*  The clipboard icon used to access  */
				  /*  the actual clipboard workspace     */
	Widget  draw;		  /*  Draw area for drawing the glyph    */
				  /*  connections			 */
	Widget	viewport;	  /*  Viewport allowing the user to use  */
				  /*  a larger virtual workspace         */
				  /*  connections			 */
	XFontStruct *font, *name_font;
	GC	    gc, gc_xor, gc_name;
	Pixmap	    modified_pix;

	Boolean	 inherit_attributes, disable_redraw, remote_execution,
		 stream_execution;
	Boolean	 view_port, auto_placement, glyph_placement, small_glyphs,
		 attach_canvas, parallel, rubberband, show_dav, show_modified,
		 show_clipboard, show_grid, demand_driven, global_variables,
		 leave_glyph, echo_exec;

	int	 grid_size;
	int	 width_factor, height_factor;
	char	 *geometry, *procedure_geometry;

/*
 *   Workspace information used for saving and restoring a workspace and
 *   other such miscellaneous information.
 */
	Boolean	 autorun, modified, compress;

/*
 *   Workspace information used for changing the activity of the
 *   undo button.
 */
	xvf_sub_form *undo;
	struct _workspace *undo_workspace;
/*
 *   Workspace variable information.  Need to record the variable definition
 *   commands to a file so that the user has a history of them.
 */
	char	*var_name;
	FILE	*var_file;

/*
 *  Machine information describing where a glyph is to be
 *  executed.  If this points to NULL then the glyph will
 *  be executed locally.  This can be over-ridden by the
 *  workspace's remote execution variable.
 */
	MachineInfo *machine;

}  Workspace;

/*
 *  These are toolkit resources for workspace.  This will change in the near
 *  future to use the resource manager, when the forms start supporting this
 *  feature.
 */
typedef struct _workspace_resources
{
	unsigned long bg, fg, grid_color, glyph_fg, glyph_bg, glyph_bd,
			destroy_fg, destroy_bg, destroy_bd, run_fg, run_bg, 
			run_bd, stop_fg, stop_bg, stop_bd, reset_fg, reset_bg,
			reset_bd, form_fg, form_bg, form_bd, input_fg, input_bg,
			input_bd, output_fg, output_bg, output_bd, label_fg,
			label_bg, label_bd, error_fg, error_bg, error_bd,
			remote_fg, remote_bg, remote_bd, name_fg;
	char	*icon_alias_file;
} WorkspaceResources;
WorkspaceResources wresource;


/*
 *  Menu structure for workspace toplevel menu.  This contains miscellaneous
 *  information in order to build a toplevel menu form for the workspace.
 */
typedef struct _menu
{
	int	num, size;
	char	**db;
	void	(*routine)();
} Menu;

#endif /* _structs_h_ */
/* Do not add after this line */
