 /*
  * Khoros: $Id: optional.c,v 1.1 1991/05/10 15:57:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: optional.c,v 1.1 1991/05/10 15:57:48 khoros Exp $";
#endif

 /*
  * $Log: optional.c,v $
 * Revision 1.1  1991/05/10  15:57:48  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  optional.c                            <<<<
   >>>>                                                       <<<<
   >>>>   description:                                        <<<<
   >>>>                                                       <<<<
   >>>>      routines:  xvl_change_optional()                 <<<<
   >>>>                 xvl_check_if_optional()               <<<<
   >>>>                 xvl_update_mutexcl()                  <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
* Routine Name:  xvl_change_optional
*
*      Purpose:  The following routine is used to change a
*		 node's optional selection to reflect if the
*		 node is currently selected or not.
*		 
*
*        Input:  node  -   the node to be changed
*
*
*   Written By: Mark Young
*
*************************************************************/


xvl_change_optional(node)

Node	*node;
{
	Glyph	  *glyph;
	Line_Info lineinfo;
	Workspace *workspace;
	char	  **database;


	glyph = node->glyph;
	workspace = glyph->workspace;
	if (glyph->type == CONTROL || glyph->type == GLYPH ||
	    glyph->type == COMMAND)
	{
	   xvf_clear_line_info(&lineinfo);
	   database = workspace->glyphform->db;
	   xvl_parse_line(database, node->selection->index, &lineinfo);

	   if (node->selected)
	   {
	      if (node->selection->mut_excl)
		 xvl_update_mutexcl(node);

	      if (lineinfo.opt_sel != node->selected)
	      {
	         xvf_change_input(workspace->glyphform, node->selection->index,
			       xvf_optsel_chng, "1", 0);
	      }
	      xvl_update_optional(node);
	   }
	   else if (node->selection->mut_excl == false)
	   {
	      if (lineinfo.opt_sel != node->selected)
	      {
	         xvf_change_input(workspace->glyphform, node->selection->index,
			    xvf_optsel_chng, "0", 0);
	      }
	      xvl_update_optional(node);
	   }
	}
}



/************************************************************
*
* Routine Name:  xvl_check_if_optional
*
*      Purpose:  The following routine is used to check if a
*		 node is an optional selection rather than a
*		 required one.
*
*        Input:  node  -   the node to be checked
*
*	Output: return True is the node is optional, otherwise
*		False is returned.
*
*
*   Written By: Mark Young
*
*************************************************************/


int xvl_check_if_optional(node)

Node	*node;
{
	Glyph	  *glyph;
	char	  **database;
	Workspace *workspace;
	Line_Info lineinfo;


	glyph = node->glyph;
	if (glyph->type == CONTROL || glyph->type == GLYPH ||
	    glyph->type == COMMAND)
	{
	   workspace = node->glyph->workspace;
	   database = workspace->glyphform->db;

	   xvf_clear_line_info(&lineinfo);
	   xvl_parse_line(database, node->selection->index, &lineinfo);
	   if (lineinfo.optional == True)
	      return(True);
	   else
	      return(False);
	}
	else
	   return(False);
}



/************************************************************
*
* Routine Name:  xvl_update_mutexcl
*
*      Purpose:  The following routine is used to update a
*		 mutual exclusive selection node.
*
*        Input:  node  -   the node to be checked
*
*	Output: return True is the node is optional, otherwise
*		False is returned.
*
*
*   Written By: Mark Young
*
*************************************************************/


xvl_update_mutexcl(node)

Node	*node;
{
	Glyph	  *glyph;
	NodeList  *links;
	Node	  *mutnode;
	Workspace *workspace;

	int	         num, type;
	mut_excl_link	 *mut_excl;
	xvf_selection	 *mutsel;
	xvf_guide_button *guide, *xvf_find_sel_guide();
	xvf_form	 *form;


	num = node->selection->mut_excl_id;
	glyph = node->glyph;
	workspace = glyph->workspace;
	form	  = workspace->glyphform;

	guide = xvf_find_sel_guide(form, node->selection->index);
	if (guide != NULL)
	{
	   mut_excl = guide->pane->mut_exclusion[num];
	   mutsel = xvf_sel_search(workspace->glyphform, mut_excl->index);
	   mut_excl->index = node->selection->index;
	   if (mutsel != node->selection)
	   {
	      if (mutsel->opt_selected == True)
	      {
	         xvf_change_input(workspace->glyphform, mutsel->index,
			       xvf_optsel_chng, "0", 0);

		 if ((mutnode = xvl_get_node(glyph, mutsel)) == NULL)
		    return;

		 mutnode->selected = False;
		 xvl_update_optional(mutnode);
		 type = xvf_get_line_type(form->db[mutsel->index]);

		 links = mutnode->links;
		 while (links != NULL)
		 {
		    if (type == InputFile)
		       xvl_delete_connection(mutnode, links->node);
		    else
		    {
		       if (links->node->filename != NULL)
			  free(links->node->filename);

		       links->node->filename = NULL;
		       xvl_update_filename(links->node);
		       xvl_delete_connection(links->node, mutnode);
		    }
		    links = mutnode->links;
		 }
	      }
	   }
	}
}
