 /*
  * Khoros: $Id: cantata.h,v 1.3 1991/12/18 09:04:05 dkhoros Exp $
  */

 /*
  * $Log: cantata.h,v $
 * Revision 1.3  1991/12/18  09:04:05  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: cantata.h
 >>>>            Author: Stephanie Hallett, Mark Young, & Carla Williams
 >>>> Date Last Updated: Fri Apr 26 14:36:12 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _cantata_h_
#define _cantata_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
#include "structs.h"
#include "vsignal.h"
#include "routines.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    cantata Argument Structure
*
****************************************************************/

typedef struct _cantata  {

/*
 *  file for ipl and cantata form definition (Optional infile)
 */
char	*form;     	/* file for ipl and cantata form definition FILENAME */
int	 form_flag;	/* file for ipl and cantata form definition FLAG */

/*
 *  file for restoring cantata workspace (Optional infile)
 */
char	*restore;     	/* file for restoring cantata workspace FILENAME */
int	 restore_flag;	/* file for restoring cantata workspace FLAG */

/*
 *  log file: where each khoros command is logged (Optional string)
 */
char	*log;       	/* log file: where each khoros command is logged STRING */
int	 log_flag;   	/* log file: where each khoros command is logged FLAG */

/*
 *  directory for I/O files (Optional string)
 */
char	*dir;       	/* directory for I/O files STRING */
int	 dir_flag;   	/* directory for I/O files FLAG */

/*
 *  verbose mode: prints out any option not used (Optional logical)
 */
int	 verbose;      	/* verbose mode: prints out any option not used LOGIC */
int	 verbose_flag;  	/* verbose mode: prints out any option not used FLAG */

/*
 *  echos the command line for each routine executed (Optional logical)
 */
int	 echo;      	/* echos the command line for each routine executed LOGIC */
int	 echo_flag;  	/* echos the command line for each routine executed FLAG */

/*
 *  displays grid in the workspace for placing glyphs (Optional logical)
 */
int	 grid;      	/* displays grid in the workspace for placing glyphs LOGIC */
int	 grid_flag;  	/* displays grid in the workspace for placing glyphs FLAG */

/*
 *  host:display.screen (Optional string)
 */
char	*display;       	/* host:display.screen STRING */
int	 display_flag;   	/* host:display.screen FLAG */

/*
 *  x value of upper-left corner of workspace (Optional integer)
 */
int	 x;    	/* x value of upper-left corner of workspace INT */
int	 x_flag;	/* x value of upper-left corner of workspace FLAG */

/*
 *  y value of upper-left corner of workspace (Optional integer)
 */
int	 y;    	/* y value of upper-left corner of workspace INT */
int	 y_flag;	/* y value of upper-left corner of workspace FLAG */

}  cantata_struct;

cantata_struct *cantata;

/* -include_additions */
Display		*display;
int		khoros_phantomd_pid;
Workspace       *main_workspace, *clipboard;
Menu            *main_menu, *clipboard_menu, *procedure_menu;
char		current_hostname[MaxLength], *current_domain;

Pixmap  form_pix,       forms_pix,
        io_pix,         ios_pix,
        io_opt_pix,     io_opts_pix,
        run_pix,        runs_pix,
        error_pix,      errors_pix,
        reset_pix,      resets_pix,
        destroy_pix,    destroys_pix,
        stop_pix,       stops_pix,
        remote_pix,     remotes_pix,
        dav_pix,        clipboard_pix,
        stippled;

/* -include_additions_end */

/* -include_macros */

/*
 *  Different glyph types in KHOROS_HOME/include/xvforms.h are defined:
#define         NONE    0
#define         SIMPLE  1
 */
#define         GLYPH   2
#define         PROCEDURE   3
#define         CONTROL 4
#define         IMAGES  5
#define         COMMENT 6
#define         COMMAND 7

/*
 *  Topological classifications of glyphs
 */
#define         SOURCE     1
#define         SINK       2
#define         TRANSFER   3
#define         INCOMPLETE 4
#define         DEAD       5

/*
 *  Different glyph types in KHOROS_HOME/include/xvforms.h are defined:
 */
#define         NORUN     0
#define         RERUN     1
#define         ONERUN    2
#define         MULTIRUN  3
#define         PARSERUN  4
#define         SIGNALRUN 5

/*
 *  Different defines which let the dispatcher know what the glyph did.
 *  If the glyph could not be scheduled because it failed to execute, or
 *  if we failed to due to failure to exec.  Or if we scheduled it but
 *  the process is still running.  Or if we dispatched the glyph and the
 *  next glyph is ready to be dispatched.
 */
#define		DISPATCH_GLYPH_FAILED    0
#define		DISPATCH_EXEC_FAILED     1
#define		DISPATCH_GLYPH_RUNNING	    2
#define		DISPATCH_GLYPH_FINISHED	    3

/*
 *  The length of the stub or butt of the connections and the rate at
 *  which the glyph appear to blink.  The blink rate is in milliseconds,
 *  so the current value (1000) is really a second.
 */
#define         StubLength	    15
#define         BlinkRate	    1000
#define         ConnectionFlowRate  100

/* -include_macros_end */

#endif
