 /*
  * Khoros: $Id: run_file.c,v 1.3 1991/12/18 09:06:20 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_file.c,v 1.3 1991/12/18 09:06:20 dkhoros Exp $";
#endif

 /*
  * $Log: run_file.c,v $
 * Revision 1.3  1991/12/18  09:06:20  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "animate.h"


/********************************************************
*
*  Routine Name:  run_animate_file
*
*       Purpose:  drives the subform 'animate_file'
*
*         Input:  form - pointer to the form tree 
*		  animate_subform_info  - information structure for subform
*					  'animate_file'
*        Output:  action of the application program
*
*     Called By:  run_animate_form()
*
*   Automatically Generated By:  conductor -i animate.form -l 3 -b
*
********************************************************/


run_animate_file(form, animate_file_info)

xvf_form *form;
animate_form_file_subform *animate_file_info;
{
	_xvf_get_file_subform(form, animate_file_info);

	/*
	 * action came from the 'file' pane
	 */
	if (animate_file_info->file_selected)
	    run_file(form, animate_file_info->file);

}   /* end run_animate_file */





/********************************************************
*
*  Routine Name:  run_file
*
*       Purpose:  drives the pane 'file'
*
*         Input:  form - pointer to the form tree 
*		  file_info  - information structure for pane 'file'
*        Output:  action of the application program
*
*     Called By:  run_animate_file()
*
*   Automatically Generated By:  conductor -i animate.form -l 3 -b
*
********************************************************/


run_file(form, file_info)

xvf_form *form;
file_subform_file *file_info;
{
	struct xvimage *image, *readimage(), *create_multimage_from_basename();


	_xvf_get_file(form, file_info);


	/*
	 * user clicked on 'live' input file selection 'c'
	 */
	if (file_info->c_selected)
	{
	   input_new_clip(file_info->c);
	}

	/*
	 * user clicked on 'live' input file selection 's'
	 */
	else if (file_info->s_selected)
	{
	   input_new_shape(file_info->s);
	}

	/*
	 * user clicked on 'live' input file selection 'i'
	 */
	else if (file_info->i_selected)
	{
           if (!(image = readimage(file_info->i)))
              return;
	   fprintf(stderr, "animate:\n");
	   fprintf(stderr, "inputting new data from file %s...\n", 
			   file_info->i);
           destroy_images(xvanimate);
	   xvdisplay->image = image;
	   xvd_update_image(xvdisplay, NULL);
           init_image(xvdisplay);
	}

	/*
	 * user clicked on 'live' string selection 'base'
	 */
	else if (file_info->base_selected)
	{
	   if (read_from_memory)
	   {
               image = create_multimage_from_basename(file_info->base);
               if (image == NULL) return(false);
	       fprintf(stderr, "animate:\n");
               fprintf(stderr, "inputting new data with basename %s...\n", 
	  		     file_info->base);
               destroy_images(xvanimate);
	       xvdisplay->image = image;
	       xvd_update_image(xvdisplay, NULL);
               init_image(xvdisplay);
	   }
	}
}

/********************************************************
*
*  Routine Name:  input_new_clip
*
*       Purpose:  brings in a bit image to be used as a clip mask when the
*                 user clicks on the live "input clip mask" selection
*
*         Input:  filename - name of the image file to be used as a clip mask
*        Output:  displays the old image masked by the new clip image
*
*     Called By:  run_file()
*
*    Written By:  Danielle Argiro & Mark Young
*
********************************************************/

input_new_clip(infile)
char *infile;
{
        char *filename, temp[MaxLength];
        struct xvimage *clip, *readimage();

        /*
         * if they put in a NULL filename, delete any existing clip masks
         */
        if (infile == NULL)
        {
            if (xvdisplay->clip != NULL)
               freeimage(xvdisplay->clip);

            xvdisplay->clip = NULL;
            xvd_update_clip(xvdisplay, NULL);
	    XSetClipMask(display, gc, NULL);
	    refresh_animate();
            return;
        }

        filename = vfullpath(infile, NULL, NULL);

        if (!(clip = readimage(filename)))
        {
           /* error in readimage */
           sprintf(temp, "Unable to read clip image from file %s.", 
		       filename);
           xvf_error_wait(temp, "animate", NULL);
	   free(filename);
           return;
        }
        xvd_update_clip(xvdisplay, clip);
	XSetClipMask(display, gc, xvdisplay->clip_mask);
        free(filename);
	refresh_animate();
}

/********************************************************
*
*  Routine Name:  input_new_shape
*
*       Purpose:  brings in a bit image to be used as a shape mask when the
*                 user clicks on the live "input shape mask" selection
*
*         Input:  filename - name of the image file to be used as a shape mask
*        Output:  displays the old image masked by the new shape image
*
*     Called By:  run_file()
*
*    Written By:  Danielle Argiro & Mark Young
*
********************************************************/

input_new_shape(infile)

char *infile;
{
        char   *filename, temp[MaxLength];
        struct xvimage *shape, *readimage();

        /*
         * if they put in a NULL filename,
         * delete any existing shape masks
         */
        if (infile == NULL)
        {
            xvdisplay->shape = NULL;
            xvd_update_shape(xvdisplay, NULL);
	    refresh_animate();
            return;
        }
        /*
         *  read in the new shape mask
         */
        filename = vfullpath(infile, NULL, NULL);
        if (!(shape = readimage(filename)))
        {
           sprintf(temp, "Unable to read shape image from file %s.", 
		   filename);
           xvf_error_wait(temp, "animate", NULL);
	   free(filename);
	   return;
        }
        xvd_update_shape(xvdisplay, shape);
	refresh_animate();
        free(filename);
}
