 /*
  * Khoros: $Id: vsamp.c,v 1.1 1991/05/10 15:51:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vsamp.c,v 1.1 1991/05/10 15:51:26 khoros Exp $";
#endif

 /*
  * $Log: vsamp.c,v $
 * Revision 1.1  1991/05/10  15:51:26  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsamp.c
 >>>>
 >>>>      Program Name: vsamp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Sample an image along an arbitrary line.
 >>>>	
 >>>>	
 >>>>            Author: Richard Krukar
 >>>>
 >>>> Date Last Updated: Thu Mar  7 15:56:36 1991
 >>>>
 >>>>          Routines: main- the main program for vsamp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vsamp.h"


/****************************************************************
 *
 * Routine Name:  main program for vsamp
 *
 *       Input:  
 *       -i  input image 
 *       -o  output image 
 *       -x1  starting x coordinate for line   (value >= 0)
 *       -x2  ending x coordinate for line   (value >= 0)
 *       -y1  starting y coordinate for line   (value >= 0)
 *       -y2  ending y coordinate for line   (value >= 0)
 *       -n  number of samples   (value > 0)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*out;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if((image = readimage(vsamp->i_file)) == NULL) {
          fprintf(stderr, "vsamp: readimage failed on input file\n");
          exit(1); }
        if (image->data_storage_type != VFF_TYP_FLOAT)
          {
            fprintf(stderr,"vsamp: Input image must be of type FLOAT\n");
            exit(1);
          }
        if (image->num_data_bands != 1 || image->map_scheme != VFF_MS_NONE)
          {
            fprintf(stderr,"vsamp: Input image must be single band, no map!\n");
            exit(1);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
if (!(lvsamp(image,&out,vsamp->x1_int,vsamp->y1_int,vsamp->x2_int,
        vsamp->y2_int,vsamp->n_int ))) {
   fprintf(stderr, "vsamp: lvsamp failed\n");
   exit(1); }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vsamp->o_file, out);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vsamp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vsamp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tSample an image along an arbitrary line.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr,"\t-x1  starting x coordinate for line  (integer, >= 0)\n");
	fprintf(stderr,"\t-x2  ending x coordinate for line  (integer, >= 0)\n");
	fprintf(stderr,"\t-y1  starting y coordinate for line  (integer, >= 0)\n");
	fprintf(stderr,"\t-y2  ending y coordinate for line  (integer, >= 0)\n");
	fprintf(stderr,"\t-n  number of samples  (integer, > 0)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vsamp\n");
	fprintf(stderr, "\t[-U] Gives the usage for vsamp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vsamp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vsamp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vsamp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*x1_pstr = 
	"\nEnter: (x1) starting x coordinate for line \n        {integer, >= 0}: "; 
char	*x2_pstr = 
	"\nEnter: (x2) ending x coordinate for line \n        {integer, >= 0}: "; 
char	*y1_pstr = 
	"\nEnter: (y1) starting y coordinate for line \n        {integer, >= 0}: "; 
char	*y2_pstr = 
	"\nEnter: (y2) ending y coordinate for line \n        {integer, >= 0}: "; 
char	*n_pstr = 
	"\nEnter: (n) number of samples \n        {integer, > 0}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vsamp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vsamp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vsamp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vsamp.ans");
		}

	     }

	}

	/*
	 * allocate the vsamp structure
	 */
	vsamp = (vsamp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vsamp_struct));

	/*
	 * get required arguments for vsamp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vsamp->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vsamp->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vsamp->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vsamp->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vsamp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vsamp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vsamp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->x1_flag = vget_int(fid, prompt_flag,
			"-x1", x1_pstr, &(vsamp->x1_int),
			0, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->x1_flag))
		{
		    fprintf(stderr, "\t\tx1 is required, please re-enter: \n");
		    vsamp->x1_flag = vget_int(fid, prompt_flag,
		    "-x1", x1_pstr, &(vsamp->x1_int),
		    0, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->x2_flag = vget_int(fid, prompt_flag,
			"-x2", x2_pstr, &(vsamp->x2_int),
			511, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->x2_flag))
		{
		    fprintf(stderr, "\t\tx2 is required, please re-enter: \n");
		    vsamp->x2_flag = vget_int(fid, prompt_flag,
		    "-x2", x2_pstr, &(vsamp->x2_int),
		    511, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-x2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->y1_flag = vget_int(fid, prompt_flag,
			"-y1", y1_pstr, &(vsamp->y1_int),
			255, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->y1_flag))
		{
		    fprintf(stderr, "\t\ty1 is required, please re-enter: \n");
		    vsamp->y1_flag = vget_int(fid, prompt_flag,
		    "-y1", y1_pstr, &(vsamp->y1_int),
		    255, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->y2_flag = vget_int(fid, prompt_flag,
			"-y2", y2_pstr, &(vsamp->y2_int),
			255, 1, 1)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->y2_flag))
		{
		    fprintf(stderr, "\t\ty2 is required, please re-enter: \n");
		    vsamp->y2_flag = vget_int(fid, prompt_flag,
		    "-y2", y2_pstr, &(vsamp->y2_int),
		    255, 1, 1);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-y2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vsamp->n_flag = vget_int(fid, prompt_flag,
			"-n", n_pstr, &(vsamp->n_int),
			1, 2, 2)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vsamp->n_flag))
		{
		    fprintf(stderr, "\t\tn is required, please re-enter: \n");
		    vsamp->n_flag = vget_int(fid, prompt_flag,
		    "-n", n_pstr, &(vsamp->n_int),
		    1, 2, 2);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-n' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



