 /*
  * Khoros: $Id: vimpulse.c,v 1.2 1991/12/18 09:39:33 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vimpulse.c,v 1.2 1991/12/18 09:39:33 dkhoros Exp $";
#endif

 /*
  * $Log: vimpulse.c,v $
 * Revision 1.2  1991/12/18  09:39:33  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vimpulse.c
 >>>>
 >>>>      Program Name: vimpulse
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create an image containing one or more unit impulses  spaced
 >>>>	as specified.
 >>>>	
 >>>>	


 >>>> 
 >>>> Date Last Updated: Tue Dec 10 15:33:59 1991
 >>>>
 >>>>          Routines: main- the main program for vimpulse
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vimpulse.h"


/****************************************************************
 *
 * Routine Name:  main program for vimpulse
 *
 *       Input:  
 *          -o  resulting impulse image 
 *
 *
 *          [-trigger] trigger input
 *          [-r] specifies the number of rows in the resulting image  (value > 0)
 *          [-c] specifies the number of columns in the resulting image  (value > 0)
 *          [-x] specifies the impulse spacing in the X direction  (value > 0)
 *          [-y] specifies the impulse spacing in the Y direction  (value > 0)
 *          [-n] specifies the number of impulses in the X direction  (value > 0)
 *          [-m] specifies the number of impulses in the Y direction  (value > 0)
 *          [-u] the X offset of first impulse from upper left corner of image  (value >= 0)
 *          [-v] the Y offset of first impulse from upper left corner of image  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    /*  If the spacing is not specified, calculate the spacing to be
        one half of the image size */
    if (vimpulse->x_flag == 0) vimpulse->x_int = vimpulse->c_int/2;
    if (vimpulse->y_flag == 0) vimpulse->y_int = vimpulse->r_int/2;

    /*  If the offset is not specified, calculate the offset to be
        one half of the image size */
    if (vimpulse->u_flag == 0) vimpulse->u_int = vimpulse->c_int/2;
    if (vimpulse->v_flag == 0) vimpulse->v_int = vimpulse->r_int/2;
/* -main_before_lib_call_end */

/* -main_library_call */
    /* Call the procedure that does the work */
    if(! lvimpulse(&image,vimpulse->x_int,vimpulse->y_int,vimpulse->n_int,
                   vimpulse->m_int,vimpulse->u_int,vimpulse->v_int,
                   vimpulse->r_int,vimpulse->c_int) )
    {
        (void) fprintf(stderr, "lvimpulse Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    (void) writeimage(vimpulse->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vimpulse 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vimpulse :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate an image containing one or more unit impulses  spaced\n");
	fprintf(stderr, "\tas specified.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting impulse image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  specifies the number of rows in the resulting image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  specifies the number of columns in the resulting image (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-x]  specifies the impulse spacing in the X direction (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-y]  specifies the impulse spacing in the Y direction (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-n]  specifies the number of impulses in the X direction (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-m]  specifies the number of impulses in the Y direction (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-u]  the X offset of first impulse from upper left corner of image (integer, >= 0) [256]\n");
	fprintf(stderr,"\t[-v]  the Y offset of first impulse from upper left corner of image (integer, >= 0) [256]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vimpulse\n");
	fprintf(stderr, "\t[-U] Gives the usage for vimpulse\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vimpulse.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vimpulse.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vimpulse
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting impulse image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) specifies the number of rows in the resulting image \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) specifies the number of columns in the resulting image \n        {integer, > 0 [512] }: "; 
char	*x_pstr = 
	"\nEnter: (x) specifies the impulse spacing in the X direction \n        {integer, > 0 [256] }: "; 
char	*y_pstr = 
	"\nEnter: (y) specifies the impulse spacing in the Y direction \n        {integer, > 0 [256] }: "; 
char	*n_pstr = 
	"\nEnter: (n) specifies the number of impulses in the X direction \n        {integer, > 0 [1] }: "; 
char	*m_pstr = 
	"\nEnter: (m) specifies the number of impulses in the Y direction \n        {integer, > 0 [1] }: "; 
char	*u_pstr = 
	"\nEnter: (u) the X offset of first impulse from upper left corner of image \n        {integer, >= 0 [256] }: "; 
char	*v_pstr = 
	"\nEnter: (v) the Y offset of first impulse from upper left corner of image \n        {integer, >= 0 [256] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vimpulse", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vimpulse.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vimpulse: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vimpulse.ans");
		}

	     }

	}

	/*
	 * allocate the vimpulse structure
	 */
	vimpulse = (vimpulse_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vimpulse_struct));

	/*
	 * get required arguments for vimpulse
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vimpulse->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vimpulse->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vimpulse->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vimpulse->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vimpulse->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vimpulse
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vimpulse->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vimpulse->trigger_file))
;

	vimpulse->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vimpulse->r_int),
	512, 2, 2);

	vimpulse->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vimpulse->c_int),
	512, 2, 2);

	vimpulse->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(vimpulse->x_int),
	256, 2, 2);

	vimpulse->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(vimpulse->y_int),
	256, 2, 2);

	vimpulse->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(vimpulse->n_int),
	1, 2, 2);

	vimpulse->m_flag = vget_int(fid, prompt_flag,
	"-m", m_pstr, &(vimpulse->m_int),
	1, 2, 2);

	vimpulse->u_flag = vget_int(fid, prompt_flag,
	"-u", u_pstr, &(vimpulse->u_int),
	256, 1, 1);

	vimpulse->v_flag = vget_int(fid, prompt_flag,
	"-v", v_pstr, &(vimpulse->v_int),
	256, 1, 1);


}



