 /*
  * Khoros: $Id: vgsin.c,v 1.3 1992/03/20 23:13:37 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgsin.c,v 1.3 1992/03/20 23:13:37 dkhoros Exp $";
#endif

 /*
  * $Log: vgsin.c,v $
 * Revision 1.3  1992/03/20  23:13:37  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgsin.c
 >>>>
 >>>>      Program Name: vgsin
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a sinusoidal image.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:36:29 1992
 >>>>
 >>>>          Routines: main- the main program for vgsin
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgsin.h"


/****************************************************************
 *
 * Routine Name:  main program for vgsin
 *
 *       Input:  
 *       -o  resulting image 
 *
 *
 *       [-trigger] trigger input
 *       [-r] number of rows  (value > 0)
 *       [-c] number of columns  (value > 0)
 *       [-b] number of data bands  (value > 0)
 *       [-m] maximum image level  (value >= 0.0)
 *       [-fx] Frequency in X direction (rad/pix)  (value >= 0.0)
 *       [-fy] Frequency in Y direction (rad/pix)  (value >= 0.0)
 *       [-px] Phase offset in X direction (radians)  (value >= 0.0)
 *       [-py] Phase offset in Y direction (radians)  (value >= 0.0)
 *       [-fs] Relative sampling frequency  (value > 0.0)
 *       [-t] Output image data type
 *		'float' (select FLOAT data type),
 *		 or 'complex' (select COMPLEX data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image;
int type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,vgsin->t_toggle)){
     fprintf(stderr,"vgsin:  Invalid data type specified\n");
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lvgsin(&image,vgsin->r_int,vgsin->c_int,vgsin->b_int,
             vgsin->m_float,vgsin->fs_float,vgsin->fx_float,vgsin->fy_float,
             vgsin->px_float,vgsin->py_float,type)){
    (void)fprintf(stderr, "lvgsin Failed\n");
    exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgsin->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgsin 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgsin :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a sinusoidal image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
printf("\nThe -t option will accept the type in either of two forms:\n");
printf("  an alphabetic representation, i.e. \'float\' or \'complex\',\n");
printf("  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  number of rows (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  number of columns (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-b]  number of data bands (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-m]  maximum image level (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-fx]  Frequency in X direction (rad/pix) (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-fy]  Frequency in Y direction (rad/pix) (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-px]  Phase offset in X direction (radians) (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-py]  Phase offset in Y direction (radians) (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-fs]  Relative sampling frequency (float, > 0.0) [1]\n");
	fprintf(stderr, "\t[-t]  Output image data type\n");
	fprintf(stderr, "\t\t'float'  (select FLOAT data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (select COMPLEX data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgsin\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgsin\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgsin.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgsin.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgsin
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, > 0 [512] }: "; 
char	*b_pstr = 
	"\nEnter: (b) number of data bands \n        {integer, > 0 [1] }: "; 
char	*m_pstr = 
	"\nEnter: (m) maximum image level \n        {float, >= 0.0 [1.000000] }: "; 
char	*fx_pstr = 
	"\nEnter: (fx) Frequency in X direction (rad/pix) \n        {float, >= 0.0 [1.000000] }: "; 
char	*fy_pstr = 
	"\nEnter: (fy) Frequency in Y direction (rad/pix) \n        {float, >= 0.0 [1.000000] }: "; 
char	*px_pstr = 
	"\nEnter: (px) Phase offset in X direction (radians) \n        {float, >= 0.0 [0.000000] }: "; 
char	*py_pstr = 
	"\nEnter: (py) Phase offset in Y direction (radians) \n        {float, >= 0.0 [0.000000] }: "; 
char	*fs_pstr = 
	"\nEnter: (fs) Relative sampling frequency \n        {float, > 0.0 [1.000000] }: "; 
char	*t_pstr = "\nEnter: (t) Output image data type -- \n      \t\t'float' (select FLOAT data type)\n\t\tor 'complex' (select COMPLEX data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgsin", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgsin.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgsin: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgsin.ans");
		}

	     }

	}

	/*
	 * allocate the vgsin structure
	 */
	vgsin = (vgsin_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgsin_struct));

	/*
	 * get required arguments for vgsin
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgsin->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgsin->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgsin->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgsin->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgsin->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgsin
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgsin->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgsin->trigger_file))
;

	vgsin->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgsin->r_int),
	512, 2, 2);

	vgsin->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgsin->c_int),
	512, 2, 2);

	vgsin->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vgsin->b_int),
	1, 2, 2);

	vgsin->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(vgsin->m_float),
	1.000000, 1.000000, 1.000000);

	vgsin->fx_flag = vget_float(fid, prompt_flag,
	"-fx", fx_pstr, &(vgsin->fx_float),
	1.000000, 1.000000, 1.000000);

	vgsin->fy_flag = vget_float(fid, prompt_flag,
	"-fy", fy_pstr, &(vgsin->fy_float),
	1.000000, 1.000000, 1.000000);

	vgsin->px_flag = vget_float(fid, prompt_flag,
	"-px", px_pstr, &(vgsin->px_float),
	0.000000, 1.000000, 1.000000);

	vgsin->py_flag = vget_float(fid, prompt_flag,
	"-py", py_pstr, &(vgsin->py_float),
	0.000000, 1.000000, 1.000000);

	vgsin->fs_flag = vget_float(fid, prompt_flag,
	"-fs", fs_pstr, &(vgsin->fs_float),
	1.000000, 2.000000, 2.000000);


	/*
	 * get optional toggles for vgsin
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vgsin->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgsin->t_toggle),
		"float");

		if (((strcmp(vgsin->t_toggle, "float") == 0)) || 
		     ((strcmp(vgsin->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vgsin->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgsin->t_toggle),
		"float");

		if (((strcmp(vgsin->t_toggle, "float") != 0)) && 
		     ((strcmp(vgsin->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



