 /*
  * Khoros: $Id: vgshot.c,v 1.2 1991/12/18 09:38:22 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgshot.c,v 1.2 1991/12/18 09:38:22 dkhoros Exp $";
#endif

 /*
  * $Log: vgshot.c,v $
 * Revision 1.2  1991/12/18  09:38:22  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgshot.c
 >>>>
 >>>>      Program Name: vgshot
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Corrupts an image uniformly with spikes (noise).
 >>>>	
 >>>>	

 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Dec 10 15:22:26 1991
 >>>>
 >>>>          Routines: main- the main program for vgshot
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgshot.h"


/****************************************************************
 *
 * Routine Name:  main program for vgshot
 *
 *       Input:  
 *        -i  input image 
 *        -o  resulting output image 
 *
 *
 *        [-trigger] trigger input
 *        [-n] spikes percentage  (0.000 < value < 100.000)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    image = readimage(vgshot->i_file);
    if (image == NULL){
        (void)fprintf(stderr,"vgshot: Image could not be read\n");
         exit(1);               /* Quit if bad image */
    }

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvgshot(image,vgshot->n_float)){
        (void) fprintf(stderr, "lvgshot Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    (void) writeimage(vgshot->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgshot 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgshot :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCorrupts an image uniformly with spikes (noise).\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-n]  spikes percentage (float,  0.000 to 100.000) [10]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgshot\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgshot\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgshot.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgshot.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgshot
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*n_pstr = 
	"\nEnter: (n) spikes percentage \n        {float,  0.000 to 100.000 [10.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgshot", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgshot.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgshot: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgshot.ans");
		}

	     }

	}

	/*
	 * allocate the vgshot structure
	 */
	vgshot = (vgshot_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgshot_struct));

	/*
	 * get required arguments for vgshot
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgshot->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vgshot->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgshot->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vgshot->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vgshot->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgshot->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgshot->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgshot->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgshot->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgshot->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgshot
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgshot->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgshot->trigger_file))
;

	vgshot->n_flag = vget_float(fid, prompt_flag,
	"-n", n_pstr, &(vgshot->n_float),
	10.000000, 0.000000, 100.000000);


}



