 /*
  * Khoros: $Id: vprmap.h,v 1.1 1991/05/10 15:49:55 khoros Exp $
  */

 /*
  * $Log: vprmap.h,v $
 * Revision 1.1  1991/05/10  15:49:55  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vprmap.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:34:11 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vprmap_h_
#define _vprmap_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vprmap Argument Structure
*
****************************************************************/

typedef struct _vprmap  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output ASCII file (Optional outfile)
 */
char	*f_file;	/* output ASCII file FILENAME */
int	 f_flag;	/* output ASCII file FLAG */

/*
 *  default: print data as matrix (Optional logical)
 */
int	 m_logic;	/* default: print data as matrix LOGIC */
int	 m_flag;  	/* default: print data as matrix FLAG */

}  vprmap_struct;

vprmap_struct *vprmap;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(vprmap->i_file); \
if (image == NULL) { \
   (void) fprintf(stderr, "vprmap: Can not read input image 1\\n"); \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKINPUT(program, image) \
    if ( ! proper_map_scheme(program, image, VFF_MS_ONEPERBAND, FALSE)) { \
       if ( ! proper_map_scheme(program, image, VFF_MS_SHARED, FALSE) ) { \
        (void) fprintf(stderr,  \
        "vprmap: ERROR Can only work on map scheme ONEPERBAND or SHARED\\n"); \
        exit(1);  /* Quit if bad image */ \
       } \
    }

/* -include_macros_end */

#endif
