 /*
  * Khoros: $Id: vprmap.c,v 1.1 1991/05/10 15:49:55 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vprmap.c,v 1.1 1991/05/10 15:49:55 khoros Exp $";
#endif

 /*
  * $Log: vprmap.c,v $
 * Revision 1.1  1991/05/10  15:49:55  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vprmap.c
 >>>>
 >>>>      Program Name: vprmap
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	vprmap prints to a file or the  screen  xviff  map  data  in
 >>>>	ascii format.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:34:11 1991
 >>>>
 >>>>          Routines: main- the main program for vprmap
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vprmap.h"


/****************************************************************
 *
 * Routine Name:  main program for vprmap
 *
 *       Input:  
 *        -i  input image filename 
 *
 *
 *        [-f] output ASCII file
 *        [-m] default: print data as matrix
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
    FILE *printdev;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);

   READINPUT(image) ;
   CHECKINPUT(program, image) ;

   if (vprmap->f_flag) 
   {
      if (! vwrite_ascii(vprmap->f_file, &printdev))
      {
         (void) fprintf(stderr, "vprmap:  Can't open ascii output file: \n");
         exit(1);
      }
   }
   else printdev = stdout;
/* -main_before_lib_call_end */

/* -main_library_call */
   if(! lvprmap(image, vprmap->m_logic,vprmap->i_file,printdev))
   {
      (void) fprintf(stderr,"vprmap: lvprmap Failed!!\n");
      exit(1);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
   fclose(printdev);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vprmap 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vprmap :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tvprmap prints to a file or the  screen  xviff  map  data  in\n");
	fprintf(stderr, "\tascii format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr,"\t[-m]  default: print data as matrix (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vprmap\n");
	fprintf(stderr, "\t[-U] Gives the usage for vprmap\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vprmap.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vprmap.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vprmap
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) default: print data as matrix \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vprmap", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vprmap.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vprmap: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vprmap.ans");
		}

	     }

	}

	/*
	 * allocate the vprmap structure
	 */
	vprmap = (vprmap_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vprmap_struct));

	/*
	 * get required arguments for vprmap
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vprmap->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vprmap->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vprmap->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vprmap->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vprmap->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vprmap
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vprmap->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(vprmap->f_file))
;

	vprmap->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vprmap->m_logic), 1);


}



