 /*
  * Khoros: $Id: vhxray.c,v 1.1 1991/05/10 15:49:41 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vhxray.c,v 1.1 1991/05/10 15:49:41 khoros Exp $";
#endif

 /*
  * $Log: vhxray.c,v $
 * Revision 1.1  1991/05/10  15:49:41  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhxray.c
 >>>>
 >>>>      Program Name: vhxray
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Enhance images using histogram stretch or equalization  with
 >>>>	overlapping windows.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer, Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:33:26 1991
 >>>>
 >>>>          Routines: main- the main program for vhxray
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhxray.h"


/****************************************************************
 *
 * Routine Name:  main program for vhxray
 *
 *       Input:  
 *        -i  first input image 
 *        -o  resulting output image 
 *        -w  selects the width of the window   (1 < value < 32)
 *        -h  selects the height of the window   (1 < value < 32)
 *
 *
 *        [-t] Choose Histogram Enhancement or Histogram Stretch
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    image = readimage(vhxray->i_file);
    if (image == NULL) exit(1);    /* Quit if bad image */

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvhxray(image, vhxray->t_logic, vhxray->w_int, vhxray->h_int))
    {
        (void) fprintf(stderr, "lvhxray Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vhxray->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhxray 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhxray :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tEnhance images using histogram stretch or equalization  with\n");
	fprintf(stderr, "\toverlapping windows.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  first input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-w  selects the width of the window  (integer, 1 to 32)\n");
	fprintf(stderr,"\t-h  selects the height of the window  (integer, 1 to 32)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  Choose Histogram Enhancement or Histogram Stretch (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhxray\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhxray\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhxray.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhxray.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhxray
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) first input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*w_pstr = 
	"\nEnter: (w) selects the width of the window \n        {integer, 1 to 32}: "; 
char	*h_pstr = 
	"\nEnter: (h) selects the height of the window \n        {integer, 1 to 32}: "; 
char	*t_pstr = 
	"\nEnter: (t) Choose Histogram Enhancement or Histogram Stretch \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhxray", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhxray.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhxray: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhxray.ans");
		}

	     }

	}

	/*
	 * allocate the vhxray structure
	 */
	vhxray = (vhxray_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhxray_struct));

	/*
	 * get required arguments for vhxray
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhxray->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhxray->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhxray->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhxray->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhxray->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhxray->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhxray->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhxray->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhxray->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhxray->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhxray->w_flag = vget_int(fid, prompt_flag,
			"-w", w_pstr, &(vhxray->w_int),
			5, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhxray->w_flag))
		{
		    fprintf(stderr, "\t\tw is required, please re-enter: \n");
		    vhxray->w_flag = vget_int(fid, prompt_flag,
		    "-w", w_pstr, &(vhxray->w_int),
		    5, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-w' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhxray->h_flag = vget_int(fid, prompt_flag,
			"-h", h_pstr, &(vhxray->h_int),
			5, 1, 32)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhxray->h_flag))
		{
		    fprintf(stderr, "\t\th is required, please re-enter: \n");
		    vhxray->h_flag = vget_int(fid, prompt_flag,
		    "-h", h_pstr, &(vhxray->h_int),
		    5, 1, 32);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-h' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vhxray
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vhxray->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vhxray->t_logic), 0);


}



