 /*
  * Khoros: $Id: vhsee.c,v 1.1 1991/05/10 15:49:31 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vhsee.c,v 1.1 1991/05/10 15:49:31 khoros Exp $";
#endif

 /*
  * $Log: vhsee.c,v $
 * Revision 1.1  1991/05/10  15:49:31  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhsee.c
 >>>>
 >>>>      Program Name: vhsee
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Determine a visible histogram of the gray-levels in  a  byte
 >>>>	type image.
 >>>>	
 >>>>	
 >>>>            Author: Mark Young, Marcelo Teran, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:33:12 1991
 >>>>
 >>>>          Routines: main- the main program for vhsee
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhsee.h"


/****************************************************************
 *
 * Routine Name:  main program for vhsee
 *
 *       Input:  
 *       -i  input image filename 
 *       -o  output image filename 
 *
 *
 *       [-p] Chose between photonegative [False] and photopositive [True]
 *       [-t] Choose displayable format [False] or plotable format [True]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *in_image, *out_image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    in_image = readimage(vhsee->i_file);
    if (in_image == NULL)       /* got a bad image */
    {
       (void) fprintf(stderr, "vhsee: ERROR Got a bad image file.\n");
       exit(1);
    }

    CHECKINPUT(program,in_image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
   if(! lvhsee(in_image, &out_image, vhsee->p_logic, vhsee->t_logic))
   {
       (void) fprintf(stderr, "lvhsee Failed\n");
       exit(1);
   }
/* -main_library_call_end */

/* -main_after_lib_call */
       writeimage(vhsee->o_file, out_image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhsee 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhsee :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tDetermine a visible histogram of the gray-levels in  a  byte\n");
	fprintf(stderr, "\ttype image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-p]  Chose between photonegative [False] and photopositive [True] (boolean) [false]\n");
	fprintf(stderr,"\t[-t]  Choose displayable format [False] or plotable format [True] (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhsee\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhsee\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhsee.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhsee.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhsee
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*p_pstr = 
	"\nEnter: (p) Chose between photonegative [False] and photopositive [True] \n        {boolean, (y/n)  [no] }: "; 
char	*t_pstr = 
	"\nEnter: (t) Choose displayable format [False] or plotable format [True] \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhsee", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhsee.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhsee: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhsee.ans");
		}

	     }

	}

	/*
	 * allocate the vhsee structure
	 */
	vhsee = (vhsee_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhsee_struct));

	/*
	 * get required arguments for vhsee
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhsee->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhsee->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhsee->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhsee->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhsee->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhsee->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhsee->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhsee->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhsee->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhsee->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vhsee
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vhsee->p_flag = vget_logic(fid, prompt_flag,
	"-p", p_pstr, &(vhsee->p_logic), 0);

	vhsee->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vhsee->t_logic), 1);


}



