 /*
  * Khoros: $Id: vmdilate.c,v 1.1 1991/05/10 15:48:38 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmdilate.c,v 1.1 1991/05/10 15:48:38 khoros Exp $";
#endif

 /*
  * $Log: vmdilate.c,v $
 * Revision 1.1  1991/05/10  15:48:38  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmdilate.c
 >>>>
 >>>>      Program Name: vmdilate
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Dilate a binary image by a structuring element.
 >>>>	
 >>>>	
 >>>>            Author: Pascal ADAM
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:31:08 1991
 >>>>
 >>>>          Routines: main- the main program for vmdilate
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmdilate.h"


/****************************************************************
 *
 * Routine Name:  main program for vmdilate
 *
 *       Input:  
 *          -i  input image 
 *          -k  input kernel 
 *          -o  output image 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *kernel,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */

   if (check_args()) exit(1);

   READINPUT(image,kernel) ;
   CHECKINPUT(program, image,kernel) ;

/* -main_before_lib_call_end */

/* -main_library_call */

   if(! lvmdilate(image,kernel))
   {
      (void) fprintf(stderr, "vmdilate: lvmdilate Failed\n");
      exit(1);
   }


/* -main_library_call_end */

/* -main_after_lib_call */
   writeimage(vmdilate->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmdilate 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmdilate :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tDilate a binary image by a structuring element.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-k  input kernel  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmdilate\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmdilate\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmdilate.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmdilate.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmdilate
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*k_pstr = 
	"\nEnter: (k) input kernel \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmdilate", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmdilate.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmdilate: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmdilate.ans");
		}

	     }

	}

	/*
	 * allocate the vmdilate structure
	 */
	vmdilate = (vmdilate_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmdilate_struct));

	/*
	 * get required arguments for vmdilate
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmdilate->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmdilate->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmdilate->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmdilate->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmdilate->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmdilate->k_flag = vget_infile(fid, prompt_flag,
			"-k", k_pstr, &(vmdilate->k_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmdilate->k_flag))
		{
		    fprintf(stderr, "\t\tk is required, please re-enter: \n");
		    vmdilate->k_flag = vget_infile(fid, prompt_flag,
		    "-k", k_pstr, &(vmdilate->k_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-k' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmdilate->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmdilate->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmdilate->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmdilate->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmdilate->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



