 /*
  * Khoros: $Id: vsdef.h,v 1.1 1991/05/10 15:48:24 khoros Exp $
  */

 /*
  * $Log: vsdef.h,v $
 * Revision 1.1  1991/05/10  15:48:24  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vsdef.h
 >>>>            Author: Pascal ADAM
 >>>> Date Last Updated: Tue Mar  5 22:29:56 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vsdef_h_
#define _vsdef_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vsdef Argument Structure
*
****************************************************************/

typedef struct _vsdef  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  output image (Required outfile)
 */
char	*o_file;	/* output image FILENAME */
int	 o_flag;	/* output image FLAG */

/*
 *  Filter Parameter GEF (Optional float)
 */
float	 a0_float;	/* Filter Parameter GEF FLOAT */
int	 a0_flag;   	/* Filter Parameter GEF FLAG */

/*
 *  1st Hysteresis Threshold (Optional integer)
 */
int	 t1_int; 	/* 1st Hysteresis Threshold INT */
int	 t1_flag;	/* 1st Hysteresis Threshold FLAG */

/*
 *  2nd Hysteresis Threshold (Optional integer)
 */
int	 t2_int; 	/* 2nd Hysteresis Threshold INT */
int	 t2_flag;	/* 2nd Hysteresis Threshold FLAG */

/*
 *  Minimum Pixel Number in a Segment (Optional integer)
 */
int	 l_int; 	/* Minimum Pixel Number in a Segment INT */
int	 l_flag;	/* Minimum Pixel Number in a Segment FLAG */

}  vsdef_struct;

vsdef_struct *vsdef;

/* -include_additions */
/*
The following define checks for proper values of:
num_of_images = 1
map_enable = VFF_MAP_OPTIONAL

and verifies that img1 and img2 match for
and verifies that img1 and img2 match for
the above fields and also
data_storage_type
col_size
row_size.
*/
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
image = readimage(vsdef->i_file);  \
if (image == NULL) {  \
   (void) fprintf(stderr,"vsdef: Can not read input image \n");  \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKINPUT(program, image) \
    propertype(program,image,VFF_TYP_1_BYTE,TRUE); \
    proper_num_images(program,image,1,TRUE);  \
    proper_num_bands(program,image,1,TRUE);  \
    proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); 
/* -include_macros_end */

#endif
