 /*
  * Khoros: $Id: vlpf.c,v 1.1 1991/05/10 15:47:57 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vlpf.c,v 1.1 1991/05/10 15:47:57 khoros Exp $";
#endif

 /*
  * $Log: vlpf.c,v $
 * Revision 1.1  1991/05/10  15:47:57  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vlpf.c
 >>>>
 >>>>      Program Name: vlpf
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Perform a low-pass filtering operation on an  image  in  the
 >>>>	frequency domain.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:47:32 1991
 >>>>
 >>>>          Routines: main- the main program for vlpf
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vlpf.h"


/****************************************************************
 *
 * Routine Name:  main program for vlpf
 *
 *       Input:  
 *      -i  first input image 
 *      -o  resulting output image 
 *      -n  selects the order of the filter   (1 < value < 6)
 *      -c  selects the cut off radius   (0.000 < value < 1.414)
 *
 *
 *      [-t] Choose Exponential Filter [False] or Butterworth Filter [True]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);
    image = readimage(vlpf->i_file);
    if (image == NULL) exit(1);  /* Quit if bad image */

    CHECKINPUT(program,image);  /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvlpf(image,vlpf->n_int,vlpf->t_logic,vlpf->c_float))
    {
         (void) fprintf(stderr, "lvlpf Failed\n");
         exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vlpf->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vlpf 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vlpf :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tPerform a low-pass filtering operation on an  image  in  the\n");
	fprintf(stderr, "\tfrequency domain.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  first input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr,"\t-n  selects the order of the filter  (integer, 1 to 6)\n");
	fprintf(stderr,"\t-c  selects the cut off radius  (float,  0.000 to 1.414)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-t]  Choose Exponential Filter [False] or Butterworth Filter [True] (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vlpf\n");
	fprintf(stderr, "\t[-U] Gives the usage for vlpf\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vlpf.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vlpf.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vlpf
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) first input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*n_pstr = 
	"\nEnter: (n) selects the order of the filter \n        {integer, 1 to 6}: "; 
char	*c_pstr = 
	"\nEnter: (c) selects the cut off radius \n        {float,  0.000 to 1.414}: "; 
char	*t_pstr = 
	"\nEnter: (t) Choose Exponential Filter [False] or Butterworth Filter [True] \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vlpf", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vlpf.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vlpf: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vlpf.ans");
		}

	     }

	}

	/*
	 * allocate the vlpf structure
	 */
	vlpf = (vlpf_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vlpf_struct));

	/*
	 * get required arguments for vlpf
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vlpf->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vlpf->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlpf->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vlpf->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vlpf->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vlpf->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vlpf->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlpf->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vlpf->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vlpf->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vlpf->n_flag = vget_int(fid, prompt_flag,
			"-n", n_pstr, &(vlpf->n_int),
			1, 1, 6)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlpf->n_flag))
		{
		    fprintf(stderr, "\t\tn is required, please re-enter: \n");
		    vlpf->n_flag = vget_int(fid, prompt_flag,
		    "-n", n_pstr, &(vlpf->n_int),
		    1, 1, 6);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-n' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vlpf->c_flag = vget_float(fid, prompt_flag,
			"-c", c_pstr, &(vlpf->c_float),
			0.500000, 0.000000, 1.414214)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vlpf->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vlpf->c_flag = vget_float(fid, prompt_flag,
		    "-c", c_pstr, &(vlpf->c_float),
		    0.500000, 0.000000, 1.414214);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vlpf
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vlpf->t_flag = vget_logic(fid, prompt_flag,
	"-t", t_pstr, &(vlpf->t_logic), 0);


}



