 /*
  * Khoros: $Id: vbandspt1.c,v 1.2 1991/10/02 00:22:10 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vbandspt1.c,v 1.2 1991/10/02 00:22:10 khoros Exp $";
#endif

 /*
  * $Log: vbandspt1.c,v $
 * Revision 1.2  1991/10/02  00:22:10  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbandspt1.c
 >>>>
 >>>>      Program Name: vbandspt1
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Extract a specified data band from a multiband image
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Wed Aug 21 15:24:57 1991
 >>>>
 >>>>          Routines: main- the main program for vbandspt1
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vbandspt1.h"


/****************************************************************
 *
 * Routine Name:  main program for vbandspt1
 *
 *       Input:  
 *           -i  input image filename 
 *           -o  output image filename 
 *
 *
 *           [-b] Data band number to extract  (value >= 0)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage(), **images_list, **create_images_list();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
image = readimage(vbandspt1->i_file);
if (image == NULL) exit(1);                   /* Quit if bad image */

                                  /* If only 1 band, dont continue */
if (image->num_data_bands == 1)
{
  (void) fprintf(stderr,"Input image only contains ONE data band!\n");
  exit(1);
}

proper_num_images(program,image,1,TRUE);

if ( vbandspt1->b_int > image->num_data_bands) {
   fprintf(stderr, "%s: Cannot extract out data band number %d,", program,vbandspt1->b_int);
   fprintf(stderr," input image\nonly contains %d data bands.\n", image->num_data_bands );
   exit(1);
}

 /* create a list of pointers to xvimage structures, the
    number in the list will be the number of data bands */

images_list = create_images_list(image->num_data_bands);
if ( images_list == NULL)
{
   (void) fprintf(stderr, "create_images_list Failed\n");
   exit(1);
}
/* -main_before_lib_call_end */

/* -main_library_call */
/* separate out all bands into separate images */

if(! lvbandsprt(image, images_list, vbandspt1->i_file, TRUE))
{
   (void) fprintf(stderr, "lvbandsprt Failed\n");
   exit(1);
}

/* since we can only extract one band, extract the band number
   specified by the -b option */

image = images_list[vbandspt1->b_int];
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vbandspt1->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vbandspt1 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vbandspt1 :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tExtract a specified data band from a multiband image\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-b]  Data band number to extract (integer, >= 0) [0]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vbandspt1\n");
	fprintf(stderr, "\t[-U] Gives the usage for vbandspt1\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vbandspt1.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vbandspt1.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vbandspt1
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) Data band number to extract \n        {integer, >= 0 [0] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vbandspt1", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vbandspt1.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vbandspt1: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vbandspt1.ans");
		}

	     }

	}

	/*
	 * allocate the vbandspt1 structure
	 */
	vbandspt1 = (vbandspt1_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vbandspt1_struct));

	/*
	 * get required arguments for vbandspt1
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vbandspt1->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vbandspt1->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbandspt1->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vbandspt1->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vbandspt1->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vbandspt1->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vbandspt1->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vbandspt1->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vbandspt1->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vbandspt1->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vbandspt1
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vbandspt1->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vbandspt1->b_int),
	0, 1, 1);


}



