 /*
  * Khoros: $Id: band2vect.h,v 1.1 1991/05/10 15:46:47 khoros Exp $
  */

 /*
  * $Log: band2vect.h,v $
 * Revision 1.1  1991/05/10  15:46:47  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: band2vect.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Tue Mar  5 22:22:36 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _band2vect_h_
#define _band2vect_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    band2vect Argument Structure
*
****************************************************************/

typedef struct _band2vect  {

/*
 *  input data file (Required infile)
 */
char	*i_file;	/* input data file FILENAME */
int	 i_flag;	/* input data file FLAG */

/*
 *  output (vector) file (Required outfile)
 */
char	*o_file;	/* output (vector) file FILENAME */
int	 o_flag;	/* output (vector) file FLAG */

}  band2vect_struct;

band2vect_struct *band2vect;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(image) \
        image = readimage(band2vect->i_file);  \
        if (image == NULL) {  \
        (void) fprintf(stderr, "band2vect: Can not read input image \n");  \
        exit(1);  /* Quit if bad image */ \
        } 

#define CHECKTYPE(program, image) \
   if (propertype(program, image, VFF_TYP_BIT, FALSE)) { \
       fprintf(stderr,"%s: data storage type must not be BIT.\n",program); \
       exit(1); \
    }

#define CHECKINPUT(program, image) \
    proper_num_images(program,image,1,TRUE);
/* -include_macros_end */

#endif
