 /*
  * Khoros: $Id: vwmdd.h,v 1.1 1991/05/10 15:46:20 khoros Exp $
  */

 /*
  * $Log: vwmdd.h,v $
 * Revision 1.1  1991/05/10  15:46:20  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vwmdd.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Apr  9 08:36:51 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vwmdd_h_
#define _vwmdd_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vwmdd Argument Structure
*
****************************************************************/

typedef struct _vwmdd  {

/*
 *  Input Image (Required infile)
 */
char	*i1_file;	/* Input Image FILENAME */
int	 i1_flag;	/* Input Image FLAG */

/*
 *  Input Center/Class Image (Required infile)
 */
char	*i2_file;	/* Input Center/Class Image FILENAME */
int	 i2_flag;	/* Input Center/Class Image FLAG */

/*
 *  Input Variance Image (Required infile)
 */
char	*i3_file;	/* Input Variance Image FILENAME */
int	 i3_flag;	/* Input Variance Image FLAG */

/*
 *  output image specifying which vector belongs to what cluster (Required outfile)
 */
char	*o_file;	/* output image specifying which vector belongs to what cluster FILENAME */
int	 o_flag;	/* output image specifying which vector belongs to what cluster FLAG */

/*
 *   specifies the scaling factor (default = 1) (Optional float)
 */
float	 k_float;	/*  specifies the scaling factor (default = 1) FLOAT */
int	 k_flag;   	/*  specifies the scaling factor (default = 1) FLAG */

/*
 *   specifies the border width in pixels (default = 0) (Optional integer)
 */
int	 b_int; 	/*  specifies the border width in pixels (default = 0) INT */
int	 b_flag;	/*  specifies the border width in pixels (default = 0) FLAG */

/*
 *  Use Summed Method (Optional logical)
 */
int	 s_logic;	/* Use Summed Method LOGIC */
int	 s_flag;  	/* Use Summed Method FLAG */

}  vwmdd_struct;

vwmdd_struct *vwmdd;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT1(image) \
    image = readimage(vwmdd->i1_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vwmdd: Image could not be read\\n"); \
        exit(1); \
    }
#define READINPUT2(center) \
    center = readimage(vwmdd->i2_file); \
    if(center == NULL){ \
        (void) fprintf(stderr,"vwmdd: Image could not be read\\n"); \
        exit(1); \
    }
#define READINPUT3(varimg) \
    varimg = readimage(vwmdd->i3_file); \
    if(varimg == NULL){ \
        (void) fprintf(stderr,"vwmdd: Image could not be read\\n"); \
        exit(1); \
    }
#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE);
/* -include_macros_end */

#endif
