 /*
  * Khoros: $Id: lvrtoc.c,v 1.2 1992/03/20 23:07:33 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvrtoc.c,v 1.2 1992/03/20 23:07:33 dkhoros Exp $";
#endif

 /*
  * $Log: lvrtoc.c,v $
 * Revision 1.2  1992/03/20  23:07:33  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvrtoc.c
 >>>>
 >>>>      Program Name: vrtoc
 >>>>
 >>>> Date Last Updated: Mon Mar  9 19:30:18 1992 
 >>>>
 >>>>          Routines: lvrtoc - the library call for vrtoc
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvrtoc - library call for vrtoc
*
* Purpose:
*    
*    Convert REAL data to COMPLEX form
*    
*    

* Input:
*    
*    image1         pointer to xvimage structure to be processed
*    
*    image2         optional  pointer  to  second  xvimage   structure
*                   (leave NULL otherwise)
*    
*    type           selects the type or REAL to COMPLEX conversion
*    
*    

* Output:
*    
*    image1         receives the output xvimage structure
*    
*    Result Value:  1 on success, 0 on failure
*    
*    

*
* Written By: Scott Wilson
*    
*    9-Mar-92 Scott Wilson Added DOUBLE support.
*    
*    

****************************************************************/


/* -library_def */
lvrtoc(image1,image2,type)
struct xvimage *image1,*image2;
int type;
/* -library_def_end */

/* -library_code */
  {
    unsigned char *c,*c2;
    short *s,*s2;
    int *i,*i2,k;
    float *f,*f2;
    double *d,*d2;
    float *cp,*cp2;
    double *dp,*dp2;
    unsigned int count;
    char *malloc();
    double mag,phase;

    count = image1->row_size*image1->col_size*image1->num_data_bands;

    /* Allocate space for the complex image */
    if (image1->data_storage_type != VFF_TYP_DOUBLE)
      {
        cp = (float *)malloc(count*sizeof(float)*2);
        if (cp == NULL)
          {
            fprintf(stderr,"lvrtoc: Unable to allocate space for COMPLEX data\n");
            return(0);
          }
        cp2 = cp;
      }
    else
      {
        dp = (double *)malloc(count*sizeof(double)*2);
        if (dp == NULL)
          {
            fprintf(stderr,"lvrtoc: Unable to allocate space for DCOMPLEX data\n");
            return(0);
          }
        dp2 = dp;
      }

    /* Figure out what type of image is coming in and then process it */
    switch(image1->data_storage_type)
      {
        case VFF_TYP_1_BYTE:
          switch(type)
            {
              case 1: /* Transfer first image to real part,
                         second to imaginary part */
                      cp = cp2;
                      c = (unsigned char *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = *c++;
                          *cp++ = 0.0;
                        }
                      if (image2 != NULL)
                        {
                          c = (unsigned char *)(image2->imagedata);
                          cp = cp2 + 1;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *c++;
                              cp++;
                            }
                        }
                      break;
              case 2: /* Transfer first image to imaginary part,
                         second to real part */
                      cp = cp2;
                      c = (unsigned char *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = 0.0;
                          *cp++ = *c++;
                        }
                      if (image2 != NULL)
                        {
                          c = (unsigned char *)(image2->imagedata);
                          cp = cp2;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *c++;
                              cp++;
                            }
                        }
                      break;
              case 3: /* Transfer first image to magnitude part,
                         second to phase part */
                      cp = cp2;
                      c = (unsigned char *)(image1->imagedata);
                      if (image2 != NULL) c2 = (unsigned char *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = *c++;
                          phase = 0.0;
                          if (image2 != NULL) phase = *c2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              case 4: /* Transfer first image to phase part,
                         second to magnitude part */
                      cp = cp2;
                      c = (unsigned char *)(image1->imagedata);
                      if (image2 != NULL) c2 = (unsigned char *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = 1.0;
                          phase = *c++;
                          if (image2 != NULL) mag = *c2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              default: fprintf(stderr,"lvrtoc: Unknown conversion\n");
                       return(0);
            }
          break;
        case VFF_TYP_2_BYTE:
          switch(type)
            {
              case 1: /* Transfer first image to real part,
                         second to imaginary part */
                      cp = cp2;
                      s = (short *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = *s++;
                          *cp++ = 0.0;
                        }
                      if (image2 != NULL)
                        {
                          s = (short *)(image2->imagedata);
                          cp = cp2 + 1;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *s++;
                              cp++;
                            }
                        }
                      break;
              case 2: /* Transfer first image to imaginary part,
                         second to real part */
                      cp = cp2;
                      s = (short *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = 0.0;
                          *cp++ = *s++;
                        }
                      if (image2 != NULL)
                        {
                          s = (short *)(image2->imagedata);
                          cp = cp2;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *s++;
                              cp++;
                            }
                        }
                      break;
              case 3: /* Transfer first image to magnitude part,
                         second to phase part */
                      cp = cp2;
                      s = (short *)(image1->imagedata);
                      if (image2 != NULL) s2 = (short *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = *s++;
                          phase = 0.0;
                          if (image2 != NULL) phase = *s2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              case 4: /* Transfer first image to phase part,
                         second to magnitude part */
                      cp = cp2;
                      s = (short *)(image1->imagedata);
                      if (image2 != NULL) s2 = (short *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = 1.0;
                          phase = *s++;
                          if (image2 != NULL) mag = *s2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              default: fprintf(stderr,"lvrtoc: Unknown conversion\n");
                       return(0);
            }
          break;
        case VFF_TYP_4_BYTE:
          switch(type)
            {
              case 1: /* Transfer first image to real part,
                         second to imaginary part */
                      cp = cp2;
                      i = (int *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = *i++;
                          *cp++ = 0.0;
                        }
                      if (image2 != NULL)
                        {
                          i = (int *)(image2->imagedata);
                          cp = cp2 + 1;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *i++;
                              cp++;
                            }
                        }
                      break;
              case 2: /* Transfer first image to imaginary part,
                         second to real part */
                      cp = cp2;
                      i = (int *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = 0.0;
                          *cp++ = *i++;
                        }
                      if (image2 != NULL)
                        {
                          i = (int *)(image2->imagedata);
                          cp = cp2;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *i++;
                              cp++;
                            }
                        }
                      break;
              case 3: /* Transfer first image to magnitude part,
                         second to phase part */
                      cp = cp2;
                      i = (int *)(image1->imagedata);
                      if (image2 != NULL) i2 = (int *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = *i++;
                          phase = 0.0;
                          if (image2 != NULL) phase = *i2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              case 4: /* Transfer first image to phase part,
                         second to magnitude part */
                      cp = cp2;
                      i = (int *)(image1->imagedata);
                      if (image2 != NULL) i2 = (int *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = 1.0;
                          phase = *i++;
                          if (image2 != NULL) mag = *i2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              default: fprintf(stderr,"lvrtoc: Unknown conversion\n");
                       return(0);
            }
          break;
        case VFF_TYP_FLOAT:
          switch(type)
            {
              case 1: /* Transfer first image to real part,
                         second to imaginary part */
                      cp = cp2;
                      f = (float *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = *f++;
                          *cp++ = 0.0;
                        }
                      if (image2 != NULL)
                        {
                          f = (float *)(image2->imagedata);
                          cp = cp2 + 1;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *f++;
                              cp++;
                            }
                        }
                      break;
              case 2: /* Transfer first image to imaginary part,
                         second to real part */
                      cp = cp2;
                      f = (float *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *cp++ = 0.0;
                          *cp++ = *f++;
                        }
                      if (image2 != NULL)
                        {
                          f = (float *)(image2->imagedata);
                          cp = cp2;
                          for (k=0; k<count; k++)
                            {
                              *cp++ = *f++;
                              cp++;
                            }
                        }
                      break;
              case 3: /* Transfer first image to magnitude part,
                         second to phase part */
                      cp = cp2;
                      f = (float *)(image1->imagedata);
                      if (image2 != NULL) f2 = (float *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = *f++;
                          phase = 0.0;
                          if (image2 != NULL) phase = *f2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              case 4: /* Transfer first image to phase part,
                         second to magnitude part */
                      cp = cp2;
                      f = (float *)(image1->imagedata);
                      if (image2 != NULL) f2 = (float *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = 1.0;
                          phase = *f++;
                          if (image2 != NULL) mag = *f2++;
                          *cp++ = mag*cos(phase);
                          *cp++ = mag*sin(phase);;
                        }
                      break;
              default: fprintf(stderr,"lvrtoc: Unknown conversion\n");
                       return(0);
            }
          break;
        case VFF_TYP_DOUBLE:
          switch(type)
            {
              case 1: /* Transfer first image to real part,
                         second to imaginary part */
                      dp = dp2;
                      d = (double *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *dp++ = *d++;
                          *dp++ = 0.0;
                        }
                      if (image2 != NULL)
                        {
                          d = (double *)(image2->imagedata);
                          dp = dp2 + 1;
                          for (k=0; k<count; k++)
                            {
                              *dp++ = *d++;
                              dp++;
                            }
                        }
                      break;
              case 2: /* Transfer first image to imaginary part,
                         second to real part */
                      dp = dp2;
                      d = (double *)(image1->imagedata);
                      for (k=0; k<count; k++)
                        {
                          *dp++ = 0.0;
                          *dp++ = *d++;
                        }
                      if (image2 != NULL)
                        {
                          d = (double *)(image2->imagedata);
                          dp = dp2;
                          for (k=0; k<count; k++)
                            {
                              *dp++ = *d++;
                              dp++;
                            }
                        }
                      break;
              case 3: /* Transfer first image to magnitude part,
                         second to phase part */
                      dp = dp2;
                      d = (double *)(image1->imagedata);
                      if (image2 != NULL) d2 = (double *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = *d++;
                          phase = 0.0;
                          if (image2 != NULL) phase = *d2++;
                          *dp++ = mag*cos(phase);
                          *dp++ = mag*sin(phase);;
                        }
                      break;
              case 4: /* Transfer first image to phase part,
                         second to magnitude part */
                      dp = dp2;
                      d = (double *)(image1->imagedata);
                      if (image2 != NULL) d2 = (double *)(image2->imagedata);
                      for (k=0; k<count; k++)
                        {
                          mag = 1.0;
                          phase = *d++;
                          if (image2 != NULL) mag = *d2++;
                          *dp++ = mag*cos(phase);
                          *dp++ = mag*sin(phase);;
                        }
                      break;
              default: fprintf(stderr,"lvrtoc: Unknown conversion\n");
                       return(0);
            }
          break;
        default:
            fprintf(stderr,"lvrtoc: Unsupported data type\n");
            return(0);
            break;
        }
    free(image1->imagedata);
    if (image1->data_storage_type != VFF_TYP_DOUBLE) 
      image1->imagedata = (char *)cp2;
    else 
      image1->imagedata = (char *)dp2;
    if (image1->data_storage_type != VFF_TYP_DOUBLE) 
      image1->data_storage_type = VFF_TYP_COMPLEX;
    else 
      image1->data_storage_type = VFF_TYP_DCOMPLEX;
    return(1);
  }
/* -library_code_end */
