 /*
  * Khoros: $Id: lvremmap.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvremmap.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvremmap.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvremmap.c
 >>>>
 >>>>      Program Name: vremmap
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:38:16 1991 
 >>>>
 >>>>          Routines: lvremmap - the library call for vremmap
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvremmap - library call for vremmap
*
* Purpose:
*    
*    Removes the map from a xvimage structure
*    
*    
* Input:
*    
*    Input to lvremmap : struct xvimage *image;
*    
*    
* Output:
*    
*    None
*    
*    
*
* Written By: Pascal ADAM
*    
*    
****************************************************************/


/* -library_def */
int lvremmap(image)
struct xvimage *image;
/* -library_def_end */

/* -library_code */
{
        char *program = "lvremmap";

       /* make some checks -- must have a map_scheme,
        * In the case of a VFF_MS_NONE map_scheme there
        * is nothing to do.
        */
        if (image->map_scheme  != VFF_MS_NONE && image->maps != NULL )
        {

           /*  This routine can operate on any type of map storage type */

           /* No Mapping is to be done, and no map are to be stored */
           image->map_scheme = VFF_MS_NONE; 

           /* The data is valid without being sent thru the col map */
           image->map_enable = VFF_MAP_OPTIONAL;

           /* No map storage type (may be useless to do it...... )  */
           image->map_storage_type = VFF_MAPTYP_NONE;

           /* No map row or column size .........................   */
           image->map_col_size = image->map_row_size = 0.0;
           image->map_subrow_size = 0.0;
 
           /* frees the memory pointed by image->maps (contains map data) */
           (void)free(image->maps);
   
           return(TRUE);
        }
        else
        {
          fprintf(stderr, "\n%s, ERROR Can not remove the image map.\n",
                   program);
          fprintf(stderr, "               This image does not contain a map\n");

           return(FALSE);
        }


}
/* -library_code_end */
