 /*
  * Khoros: $Id: lvdither.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvdither.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvdither.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvdither.c
 >>>>
 >>>>      Program Name: vdither
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:08:19 1991 
 >>>>
 >>>>          Routines: lvdither - the library call for vdither
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/*  Dither matrix, four-point star type  */
unsigned char t1[5][5] = {  40,  80, 140, 120,  20,
                            60, 170, 210, 190, 100,
                           150, 240, 250, 230, 160,
                            90, 200, 220, 180,  50,
                            10, 110, 130,  70,  30 };

/*  Dither matrix, box type */
unsigned char t2[5][5] = { 138, 230,   5, 219, 107,
                            87,  46, 179,  67, 148,
                           189,  26, 250,  15, 199,
                           158,  77, 168,  56,  97,
                           128, 209,  36, 240, 117 };
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvdither - library call for vdither
*
* Purpose:
*    
*    Perform dithering using ordered (matrix) technique.
*    
*    
* Input:
*    
*    image          xvimage structure containing the  character  image
*                   to be dithered.
*    
*    type           an integer flag indicating the type  of  dithering
*                   (matrix) technique desired.
*    
*    
* Output:
*    
*    image          holds the result of the dithered image.
*    
*    Return Value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran (1/11/88)  Converted to new xvstruct.
*    Mark Young (5/9/88)  Changed bitmap padding  from  16  to  8
*    bits.
*    
*    
****************************************************************/


/* -library_def */
lvdither(image, type)
struct xvimage *image;
int  type;
/* -library_def_end */

/* -library_code */
{
    int k,it,jt,n;
    int  i,j,bmsize;
    char *malloc();
    unsigned char *cptr, *bptr, *b, bit;

    if (image->data_storage_type != VFF_TYP_1_BYTE)
    {
       (void) fprintf(stderr,"lvdither: ");
       (void) fprintf(stderr,"sorry can only dither byte images.\n");
       return(0);
    }

    n = 5; it = 0;
    cptr = (unsigned char *)(image->imagedata);
    for(i=0;i<image->col_size;i++)               /* For each line */
    {
        jt = 0;
        for(j=0;j<image->row_size;j++)                  /* For each pixel */
        {
            /* Check dither matrix element at index point for grey level */
            if (type == 1) /* Four-point star */
            {
                if(t1[it][jt] > *cptr) *cptr = 0;
                else *cptr = ~0;
            }
            else if (type == 0) /* Box */
            {
                if(t2[it][jt] > *cptr) *cptr = 0;
                else *cptr = ~0;
            }
            else
            {
                fprintf(stderr,"lvdither: Unknown dither type: %d\n",type);
                return(0);
            }
            jt=(jt+1)%n;                         /* Advance index point */
            cptr++;
        }
        it=(it+1)%n;                             /* Advance index point */
    }

    bmsize = ((image->row_size + 7)/8)*image->col_size;
    bptr = (unsigned char *)malloc(bmsize);
    if (bptr == NULL) {
        fprintf(stderr,"vdither: unable to allocate memory.\n");
        return(0);
    }
    b = bptr;
    cptr = (unsigned char *)(image->imagedata);
    for (i=0; i<image->col_size; i++)
    {
        k = 0;
        for (j=0; j<image->row_size; j++)
        {
            bit = 1 << k;      /* Bit to set or clear */
            if (*cptr++ > 128) *b = *b | bit;
            else *b = *b & ~bit;
            if (k == 7)
            {
                k = 0;
                b++;
            }
            else k++;
        }
        if (k != 0)
        {
            for (j=k; j<8; j++) *b = *b & (~(1 << j));
            b++;
        }
    }
    image->imagedata = (char *)bptr;
    image->data_storage_type =  VFF_TYP_BIT;

    return(1);
}
/* -library_code_end */
