 /*
  * Khoros: $Id: lvclip.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvclip.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvclip.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvclip.c
 >>>>
 >>>>      Program Name: vclip
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:56:40 1991 
 >>>>
 >>>>          Routines: lvclip - the library call for vclip
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvclip - library call for vclip
*
* Purpose:
*    
*    Clip the range of grey level values
*    
*    
* Input:
*    
*    image          Input image to be clipped
*    
*    upper          Upper clipping level
*    
*    lower          Lower clipping level
*    
*    
* Output:
*    
*    image          holds the result of the  clipping  operation.  The
*                   output  data  type  is  the same as the input data
*                   type.
*    
*    Return value:  1 on success, 0 on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Scott Wilson 27-Jan-91 - Removed FFT data type handling.
*    
*    
****************************************************************/


/* -library_def */
int
lvclip(image,upper,lower)
struct xvimage *image;
float upper,lower;
/* -library_def_end */

/* -library_code */
  {
    unsigned char *c;
    short  *s;
    int    *i, j, k;
    float  *f, fv;

    if (lower > upper) {
      (void) fprintf(stderr,"lvclip: Lower level greater than upper level!\n");
      return(0);
    }

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          (void) fprintf(stderr,"lvclip: Don't know how to clip BIT images\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          k = image->row_size*image->col_size*image->num_data_bands;
          c = (unsigned char *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*c) < lower) *c = lower;
              else if ((float)(*c) > upper) *c = upper;
              c++;
            }
          break;
        case VFF_TYP_2_BYTE :
          k = image->row_size*image->col_size*image->num_data_bands;
          s = (short *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*s) < lower) *s = lower;
              else if ((float)(*s) > upper) *s = upper;
              s++;
            }
          break;
        case VFF_TYP_4_BYTE :
          k = image->row_size*image->col_size*image->num_data_bands;
          i = (int *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*i) < lower) *i = lower;
              else if ((float)(*i) > upper) *i = upper;
              i++;
            }   
          break;
        case VFF_TYP_FLOAT :
          k = image->row_size*image->col_size*image->num_data_bands;
          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              if ((float)(*f) < lower) *f = lower;
              else if ((float)(*f) > upper) *f = upper;
              f++;
            }   
          break;
        case VFF_TYP_COMPLEX :
          k = image->row_size*image->col_size*image->num_data_bands;

          f = (float *)(image->imagedata);
          for (j=0; j<k; j++)
            {
              fv =sqrt((double)((*f * *f) + (*(f+1) * *(f+1))));
              if (fv < lower) { *f = lower; *(f+1) = 0.0; }
              else if (fv > upper) { *f = upper; *(f+1) = 0.0; }
              f += 2;  
            }
          break;
        default:
          (void) fprintf(stderr,"lvclip: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
  }
/* -library_code_end */
