 /*
  * Khoros: $Id: get_line.c,v 1.2 1991/10/01 23:57:32 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: get_line.c,v 1.2 1991/10/01 23:57:32 khoros Exp $";
#endif

 /*
  * $Log: get_line.c,v $
 * Revision 1.2  1991/10/01  23:57:32  khoros
 * HellPatch2
 *
  */ 


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>     file name: get_line.c                             <<<<
   >>>>                                                       <<<<
   >>>>   description: see below                              <<<<
   >>>>                                                       <<<<
   >>>>      routines: get_line                               <<<<
   >>>>                rewrite                                <<<<
   >>>>                                                       <<<<
   >>>>        author: W. Tait Cyrus -- May 31, 1990          <<<<
   >>>>                                                       <<<<
   >>>> modifications:                                        <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

#include "imkmf.h"

/*
 * This routine reads in a "line" from the specified stream putting the
 * characters into the specified iobuffer.  A "line" may be separated
 * by NEWLINES as long as a backslash (\) precedes the NEWLINE.  If
 * a backslash does not precede the NEWLINE, then that marks the end
 * of the "line".
 */

int
get_line(iobuffer, stream) 
   char *iobuffer;
   FILE *stream;
   {
   int index;
   int c;
   int eol;
   int eof;
   int line_continued;

   eol = FALSE;
   eof = FALSE;
   index = 0;
   line_continued = FALSE;

   while( !eol && !eof && (index < MAXLINE) ) {
      c = getc( stream );
      switch( c ) {
	 case EOF:
	    eof = TRUE;
	    break;
	 case '\\':
	    line_continued = TRUE;
	    break;
	 case '\n':
	    if( !line_continued ) {
	       eol = TRUE;
	       iobuffer[ index++ ] = '\n';
	       iobuffer[ index ] = 0;
	       }
	    else {
	       line_continued = FALSE;
	       iobuffer[ index++ ] = MAGIC;
	       }
	    break;
	 default:
	    iobuffer[ index++] = c;
	 }
      }
   return( !eof );
   }

/*
 * This routine takes the specified `line' and writes it to `output'.
 * The `line' may contain a MAGIC character which represents the
 * fact that the original file contained line continuation characters (\)
 * so we rewrite the line in its original form by replacing the MAGIC
 * characters with backslashes (\).
 */

rewrite( line, outfile )
   unsigned char *line;
   FILE *outfile;
   {
   while( *line != 0 ) {
      if( *line == MAGIC ) fprintf( outfile, "\\\n" );
      else putc( *line, outfile );
      line++;
      }
   }
