#! /bin/csh -f

# 
#  Khoros: $Id: vmanwhatis.csh,v 1.3 1991/12/18 08:55:28 dkhoros Exp $
#

#
# $Log: vmanwhatis.csh,v $
# Revision 1.3  1991/12/18  08:55:28  dkhoros
# HellPatch3
#
# 

#
#*----------------------------------------------------------------------
#*
#* Copyright 1990, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: vmanwhatis.csh                          <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros man pages
#  >>>>                                                       <<<<
#  >>>> modifications:					      <<<<
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME:	vmanwhatis.csh
# 
# AUTHORS:	Ron E. Neher & Tom Sauer
# 
# DATE:		2/10/89
# 
# DESCRIPTION:	make the $KHOROS_HOME/man/whatis file for 'vman -k'
# 
# MODIFICATIONS: Tom Sauer -  Mon Apr  8 15:30:28 MDT 1991
#		 incorporated the awk program into this program.
#		 put a command line on vmanwhatis
#		 added functionality for Khoros Contrib
# 
onintr cleanup

set path = ( /usr/local/bin /usr/new /usr/ucb /usr/bin /bin \
    /usr/local/etc/ /usr/etc /etc/ /usr/hosts $KHOROS_HOME/bin . )

# Set up environment variables
#----------------------------------------------------------
if (! $?KHOROS_HOME) then
   echo ""
   echo "vmanwhatis: Error, must have the KHOROS_HOME "
   echo "            environment variable set to proceed."
   echo ""
   exit 1
endif

set args = ""

umask 002

set d_flg1  = 0
set d_flg2  = 0

while ($#argv)
    switch ($argv[1])
	case -U:
	    goto usage
	    breaksw
	case -V:
	    goto version
	    breaksw
	case -toolbox:                # set manpath flag
            if ($d_flg1 || $d_flg2) goto usage
            set d_flg1 = 1
	    breaksw
	default:
            if ($d_flg1) then             # get fullpath dir
                set d_flg1 = 0
                set d_flg2 = 1
                set TOOLBOX = $argv[1]
	    endif
	    breaksw
    endsw
    shift
end

# check to see if -f or -r is still set
#-----------------------------------------------------
    if ($d_flg1) goto usage


#-----------------------------------------------------
if ( ! $d_flg2) then
   set MANPATH = $KHOROS_HOME/man 
else
   if ($?KHOROS_TOOLBOX) then
     set MANPATH = `grep -i $TOOLBOX $KHOROS_TOOLBOX | awk -F: '{ printf "%s/man", $2 }' `
     set MANPATH = `eval echo $MANPATH`
   else
    echo ""
    echo "vmanwhatis: Error, A toolbox was specified, but the environment"
    echo "            KHOROS_TOOLBOX has not been set. Please use 'setenv'"
    echo "            to set the KHOROS_TOOLBOX environment variable"
    echo ""
    exit 1
  endif
endif


endif 

if ($MANPATH == "") then
   echo ""
   echo "vmanwhatis: Error, An invalid toolbox was specified or the man"
   echo "            directory for the toolbox '$TOOLBOX' does not exist"
   echo "            does not exist"
   echo ""
   exit 1
endif


if (! -d $MANPATH) then
   echo ""
   echo "vmanwhatis: Error, the directory '$MANPATH)'"
   echo "            does not exist"
   echo ""
   exit 1
endif

# ----------------------------------------------------------------------
# generate the awk program to parse the man files
#

echo -n "vmanwhatis: generating the whatis file... "
set TEMPDIR = /tmp
touch $TEMPDIR/awk.$$

echo 'BEGIN { ' >> $TEMPDIR/awk.$$
echo '    FS = " "; flg = 0; name = " "; desc = " " ' >> $TEMPDIR/awk.$$
echo '}' >> $TEMPDIR/awk.$$
echo '{ ' >> $TEMPDIR/awk.$$
echo '    if ($1 == ".TH") ' >> $TEMPDIR/awk.$$
echo '    { ' >> $TEMPDIR/awk.$$
echo '        name = $2 ' >> $TEMPDIR/awk.$$
echo '        section = "(" $3 ")" ' >> $TEMPDIR/awk.$$
echo '    } ' >> $TEMPDIR/awk.$$
echo '    if (flg == 1) ' >> $TEMPDIR/awk.$$
echo '    { ' >> $TEMPDIR/awk.$$
echo '        desc = $3 " " ' >> $TEMPDIR/awk.$$
echo '        for (i = 4; i <= NF; i++) desc = desc $i " " ' >> $TEMPDIR/awk.$$
echo '        exit ' >> $TEMPDIR/awk.$$
echo '    } ' >> $TEMPDIR/awk.$$
echo '    if ($2 == "NAME" || $2 == "PROGRAM" || $2 == "LIBRARY") flg = 1 ' >> $TEMPDIR/awk.$$
echo '} ' >> $TEMPDIR/awk.$$
echo ' ' >> $TEMPDIR/awk.$$
echo 'END { ' >> $TEMPDIR/awk.$$
echo '    print name,section,"		- ", desc ' >> $TEMPDIR/awk.$$
echo '} ' >> $TEMPDIR/awk.$$


set okman1 = 0
set okman3 = 0
set okmann = 0

if (-e /tmp/whatis.1.$$) then
    \rm -rf /tmp/whatis.1.$$
endif
if (-e /tmp/whatis.n.$$) then
    \rm -rf /tmp/whatis.n.$$
endif
if (-e /tmp/whatis.3.$$) then
    \rm -rf /tmp/whatis.3.$$
endif

set nonomatch

if ( -e $MANPATH/man1 ) then
   foreach file ( $MANPATH/man1/*.1 )
      if ( -e $file) then
         set okman1 = 1
         awk -f $TEMPDIR/awk.$$ $file >> /tmp/whatis.1.$$
      endif
   end
endif

if ( -e $MANPATH/mann ) then
   foreach file ( $MANPATH/mann/*.n)
      if ( -e $file) then
         set okmann = 1
         awk -f $TEMPDIR/awk.$$ $file >> /tmp/whatis.n.$$
      endif
   end
endif
if ( -e $MANPATH/man3 ) then
   foreach file ( $MANPATH/man3/*.3 )
      if ( -e $file) then
         set okman3 = 1
         awk -f $TEMPDIR/awk.$$ $file >> /tmp/whatis.3.$$
      endif
   end
endif

if ( -e $MANPATH/whatis) then
   \rm -f $MANPATH/whatis
endif
touch $MANPATH/whatis

if ( $okman1 == 1 ) then
   sort /tmp/whatis.1.$$ >> $MANPATH/whatis
   \rm -f /tmp/whatis.1.$$
endif
if ( $okman3 == 1 ) then
   sort /tmp/whatis.3.$$ >> $MANPATH/whatis
   \rm -f /tmp/whatis.3.$$
endif
if ( $okmann == 1 ) then
   sort /tmp/whatis.n.$$ >> $MANPATH/whatis
   \rm -f /tmp/whatis.n.$$
endif

chmod 664 $MANPATH/whatis

echo "done"
goto cleanup


# -------------------------------------------------------
usage:
    echo ""
    echo "vmanwhatis:  make the whatis file for 'vman -k'"
    echo ""
    echo ""
    echo "usage:"
    echo "  vmanwhatis [-V] [-U] [-d man directory ]"
    echo ""
    echo "where: " 
    echo "        [-V]   gives the version for vmanwhatis"
    echo "        [-U]   gives the usage for vmanwhatis"
    echo "        [-toolbox]   the man directory where the whatis file is created"
    echo ""
    echo "If NO toolbox (-toolbox) is specified, then KHOROS_HOME/man is used."
    echo ""
    echo ""
    exit 0

version:
    source $KHOROS_HOME/repos/config/scripts/script_version
    set VERSION = $KHOROS_VERSION
    set RELEASE = $KHOROS_RELEASE
    echo ""
    echo "vmanwhatis:  Khoros Release: Version $VERSION.$RELEASE"
    echo ""
    unset KHOROS_VERSION
    unset KHOROS_RELEASE
    exit 0

cleanup:

/bin/rm -f $TEMPDIR/awk.$$
exit 0  # normal exit
