 /*
  * Khoros: $Id: vbilinco.h,v 1.1 1991/05/10 15:52:12 khoros Exp $
  */

 /*
  * $Log: vbilinco.h,v $
 * Revision 1.1  1991/05/10  15:52:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vbilinco.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Thu Mar 28 00:20:22 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vbilinco_h_
#define _vbilinco_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vbilinco Argument Structure
*
****************************************************************/

typedef struct _vbilinco  {

/*
 *  Source tie point image (Required infile)
 */
char	*i1_file;	/* Source tie point image FILENAME */
int	 i1_flag;	/* Source tie point image FLAG */

/*
 *  Target tie point image (Required infile)
 */
char	*i2_file;	/* Target tie point image FILENAME */
int	 i2_flag;	/* Target tie point image FLAG */

/*
 *  X vwarp coefficients image (Required outfile)
 */
char	*o1_file;	/* X vwarp coefficients image FILENAME */
int	 o1_flag;	/* X vwarp coefficients image FLAG */

/*
 *  Y vwarp coefficients image (Required outfile)
 */
char	*o2_file;	/* Y vwarp coefficients image FILENAME */
int	 o2_flag;	/* Y vwarp coefficients image FLAG */

/*
 *  Tiepoint Error Image (Optional outfile)
 */
char	*o3_file;	/* Tiepoint Error Image FILENAME */
int	 o3_flag;	/* Tiepoint Error Image FLAG */

}  vbilinco_struct;

vbilinco_struct *vbilinco;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img1, img2) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) match_num_images(program,img1,img2,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        (void) match_num_bands(program,img1,img2,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE);   \
        (void) match_map_enable(program,img1,img2,TRUE); \
        \
        (void) matchsize(program,img1,img2,TRUE); \
        (void) matchtype(program,img1,img2,TRUE); \
        \
        (void) propertype(program,img1,VFF_TYP_FLOAT,TRUE); \
        (void) propertype(program,img2,VFF_TYP_FLOAT,TRUE)
/* -include_macros_end */

#endif
