 /*
  * Khoros: $Id: vgettilt.c,v 1.2 1991/10/02 00:04:16 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgettilt.c,v 1.2 1991/10/02 00:04:16 khoros Exp $";
#endif

 /*
  * $Log: vgettilt.c,v $
 * Revision 1.2  1991/10/02  00:04:16  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgettilt.c
 >>>>
 >>>>      Program Name: vgettilt
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	computes the best-fit plane parameters for  the  input  VIFF
 >>>>	file
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson, Donna Koechner
 >>>>
 >>>> Date Last Updated: Thu Sep 26 11:12:06 1991
 >>>>
 >>>>          Routines: main- the main program for vgettilt
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgettilt.h"


/****************************************************************
 *
 * Routine Name:  main program for vgettilt
 *
 *       Input:  
 *          -i  input image 
 *          -f  output ASCII file 
 *
 *
 *          [-m] statistics operation masking image
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1,*img2, *readimage();
FILE            *printdev;
double          xslope, yslope, piston;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s:  Illegal arguments on command line.\n",program);
  exit(1);
}

if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT(img1) ;
READMASK(img2) ;
CHECKINPUT(program, img1) ;
MATCHINPUT(program, img1, img2) ;

if (vgettilt->f_flag)
{
  if (! vwrite_ascii(vgettilt->f_file, &printdev))
  {
    (void) fprintf(stderr, "vgettilt:  Can't open ascii output file: \n");
    exit(1);
  }
}
else
printdev = stdout;

/* -main_before_lib_call_end */

/* -main_library_call */
if (! lvgettilt(img1,img2, vgettilt->m_flag, &xslope,&yslope,&piston) )
{
  (void)fprintf(stderr,"%s: lvgettilt failed!\n", program);
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
(void) fprintf(printdev,"\nImage Tilt Information for File Name: %s\n",
vgettilt->i_file);

(void) fprintf(printdev,"    X Slope: %g per pixel\n",xslope);
(void) fprintf(printdev,"    Y Slope: %g per pixel\n",yslope);
(void) fprintf(printdev,"    Piston : %g\n",piston);

fclose(printdev);

exit(0);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgettilt 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgettilt :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tcomputes the best-fit plane parameters for  the  input  VIFF\n");
	fprintf(stderr, "\tfile\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-f  output ASCII file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  statistics operation masking image (infile) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgettilt\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgettilt\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgettilt.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgettilt.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgettilt
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) statistics operation masking image \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgettilt", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgettilt.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgettilt: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgettilt.ans");
		}

	     }

	}

	/*
	 * allocate the vgettilt structure
	 */
	vgettilt = (vgettilt_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgettilt_struct));

	/*
	 * get required arguments for vgettilt
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgettilt->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vgettilt->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgettilt->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vgettilt->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vgettilt->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgettilt->f_flag = vget_outfile(fid, prompt_flag,
			"-f", f_pstr, &(vgettilt->f_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgettilt->f_flag))
		{
		    fprintf(stderr, "\t\tf is required, please re-enter: \n");
		    vgettilt->f_flag = vget_outfile(fid, prompt_flag,
		    "-f", f_pstr, &(vgettilt->f_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-f' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgettilt
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgettilt->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vgettilt->m_file))
;


}



