 /*
  * Khoros: $Id: mcovar.h,v 1.1 1991/05/10 15:55:42 khoros Exp $
  */

 /*
  * $Log: mcovar.h,v $
 * Revision 1.1  1991/05/10  15:55:42  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: mcovar.h
 >>>>            Author: Scott Wilson
 >>>> Date Last Updated: Fri Mar 29 18:43:51 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _mcovar_h_
#define _mcovar_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    mcovar Argument Structure
*
****************************************************************/

typedef struct _mcovar  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

}  mcovar_struct;

mcovar_struct *mcovar;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, image) \
        proper_num_images(program,image,1,TRUE); \
        if (propertype(program,image,VFF_TYP_BIT,FALSE) || \
            propertype(program,image,VFF_TYP_2_BYTE,FALSE) || \
            propertype(program,image,VFF_TYP_4_BYTE,FALSE) || \
            propertype(program,image,VFF_TYP_DOUBLE,FALSE)) \
        { \
            (void) fprintf(stderr, "Image data type must be \
VFF_TYP_1_BYTE || VFF_TYP_FLOAT\n"); \
            exit(1); \
        } \
        proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        proper_map_scheme(program,image,VFF_MS_NONE,TRUE)
/* -include_macros_end */

#endif
