 /*
  * Khoros: $Id: viff2pbm.c,v 1.2 1991/10/02 00:31:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viff2pbm.c,v 1.2 1991/10/02 00:31:48 khoros Exp $";
#endif

 /*
  * $Log: viff2pbm.c,v $
 * Revision 1.2  1991/10/02  00:31:48  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viff2pbm.c
 >>>>
 >>>>      Program Name: viff2pbm
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Converts a VIFF image to a PBM image.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage and Mark Young
 >>>>
 >>>> Date Last Updated: Sat Mar  2 14:43:44 1991
 >>>>
 >>>>          Routines: main- the main program for viff2pbm
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viff2pbm.h"


/****************************************************************
 *
 * Routine Name:  main program for viff2pbm
 *
 *       Input:  
 *          -i  input viff image file 
 *          -o  output resulting pbm file definition 
 *
 *
 *          [-r] File format: ASCII(0) or RAW(1)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct pbm      *pbm;
    struct xvimage  *viff, *readimage();
    char *program;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        viff = readimage(viff2pbm->i_file);
        if (viff == NULL)
        {
           (void) fprintf(stderr,"%s: Could not read input image.\n",program);
           exit(1);
        }

/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lviff2pbm(viff, &pbm, viff2pbm->r_logic))
        {
           (void) fprintf(stderr, "lviff2pbm Failed.\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        write_pbm(viff2pbm->o_file, pbm);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viff2pbm 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viff2pbm :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConverts a VIFF image to a PBM image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input viff image file  (infile)\n");
	fprintf(stderr,"\t-o  output resulting pbm file definition  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-r]  File format: ASCII(0) or RAW(1) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for viff2pbm\n");
	fprintf(stderr, "\t[-U] Gives the usage for viff2pbm\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viff2pbm.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viff2pbm.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viff2pbm
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input viff image file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output resulting pbm file definition \n        {outfile}: "; 
char	*r_pstr = 
	"\nEnter: (r) File format: ASCII(0) or RAW(1) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viff2pbm", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viff2pbm.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viff2pbm: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viff2pbm.ans");
		}

	     }

	}

	/*
	 * allocate the viff2pbm structure
	 */
	viff2pbm = (viff2pbm_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viff2pbm_struct));

	/*
	 * get required arguments for viff2pbm
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viff2pbm->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(viff2pbm->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2pbm->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    viff2pbm->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(viff2pbm->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(viff2pbm->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(viff2pbm->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viff2pbm->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    viff2pbm->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(viff2pbm->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viff2pbm
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viff2pbm->r_flag = vget_logic(fid, prompt_flag,
	"-r", r_pstr, &(viff2pbm->r_logic), 0);


}



