 /*
  * Khoros: $Id: dlg2viff.c,v 1.1 1991/05/10 15:52:40 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dlg2viff.c,v 1.1 1991/05/10 15:52:40 khoros Exp $";
#endif

 /*
  * $Log: dlg2viff.c,v $
 * Revision 1.1  1991/05/10  15:52:40  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dlg2viff.c
 >>>>
 >>>>      Program Name: dlg2viff
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convert a DLG format vector file to VIFF format.
 >>>>	
 >>>>	
 >>>>            Author: Per Lysne
 >>>>
 >>>> Date Last Updated: Tue Apr  9 12:53:36 1991
 >>>>
 >>>>          Routines: main- the main program for dlg2viff
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dlg2viff.h"


/****************************************************************
 *
 * Routine Name:  main program for dlg2viff
 *
 *       Input:  
 *          -i  Input DLG File 
 *
 *
 *          [-o1] Output File For DLG Category #1
 *          [-o2] Output File For DLG Category #2
 *          [-o3] Output File For DLG Category #3
 *          [-o4] Output File For DLG Category #4
 *          [-x] Number Of Columns In The Output Image  (value > 0)
 *          [-l] location options
 *		0 (No Location Data),
 *		1 (Sparse Location Data),
 *		or 2 (Full Location Data)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
int rows, cols;
double delta_x, delta_y;
struct dlgimage *dlg_img, *readdlg();
struct xvimage *xv_img1, *xv_img2, *xv_img3, *xv_img4;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    /*
     * Read the input dlg file.
     */
    dlg_img = readdlg (dlg2viff->i_file);
    if (dlg_img == NULL) {
        fprintf (stderr, "error in dlg2viff: ");
        fprintf (stderr, "could not read dlg file: %s\n", dlg2viff->i_file);
        exit (1);
    }

    /*
     * Make sure that the number of columns selected for the output image is
     * a multiple of 8.  This is necessary because the output is a bit image
     * and a row must have a whole number of bytes.
     */
    if (dlg2viff->x_int%8 != 0) {
        fprintf (stderr, "error in dlg2viff: ");
        fprintf (stderr, "number of columns must be a multiple of 8\n");
        exit (1);
    }

    /*
     * Set up a ratio between the length and the area covered by the dlg
     * data to calculate the number of rows that the output image should
     * have.  This is done so the output dlg map will be correctly 
     * proportioned.
     */
    cols = dlg2viff->x_int;
    delta_x = dlg_img->corners[SW][INTERNAL_X]-dlg_img->corners[SE][INTERNAL_X];
    delta_x = fabs(delta_x);
    delta_y = dlg_img->corners[SW][INTERNAL_Y]-dlg_img->corners[NW][INTERNAL_Y];
    delta_y = fabs(delta_y);
    rows = (int) ((delta_y/delta_x) * cols);
/* -main_before_lib_call_end */

/* -main_library_call */
    /*
     * Set all the image pointers to NULL.  If they return from the library
     * with a NULL value it means there was not a category in the dlg file
     * to assign to them.
     */
    xv_img1 = xv_img2 = xv_img3 = xv_img4 = NULL;

    if (!ldlg2viff(dlg_img, rows, cols, dlg2viff->l_toggle,
        &xv_img1, &xv_img2, &xv_img3, &xv_img4)) {
        fprintf (stderr, "error in dlg2viff: call to ldlg2viff failed\n");
        exit (1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    /*
     * Write the output files.
     */
    if ((dlg2viff->o1_flag) && (xv_img1 != NULL)) {
        if (!writeimage(dlg2viff->o1_file, xv_img1)) {
            fprintf (stderr, "error in dlg2viff: could not write output file ");
            fprintf (stderr, "for category #1: %s\n", dlg2viff->o1_file);
            exit (1);
        }
    }

    if ((dlg2viff->o2_flag) && (xv_img2 != NULL)) {
        if (!writeimage(dlg2viff->o2_file, xv_img2)) {
            fprintf (stderr, "error in dlg2viff: could not write output file ");
            fprintf (stderr, "for category #2: %s\n", dlg2viff->o2_file);
            exit (1);
        }
    }

    if ((dlg2viff->o3_flag) && (xv_img3 != NULL)) {
        if (!writeimage(dlg2viff->o3_file, xv_img3)) {
            fprintf (stderr, "error in dlg2viff: could not write output file ");
            fprintf (stderr, "for category #3: %s\n", dlg2viff->o3_file);
            exit (1);
        }
    }

    if ((dlg2viff->o4_flag) && (xv_img4 != NULL)) {
        if (!writeimage(dlg2viff->o4_file, xv_img4)) {
            fprintf (stderr, "error in dlg2viff: could not write output file ");
            fprintf (stderr, "for category #4: %s\n", dlg2viff->o4_file);
            exit (1);
        }
    }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dlg2viff 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dlg2viff :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvert a DLG format vector file to VIFF format.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  Input DLG File  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-o1]  Output File For DLG Category #1 (outfile) [null]\n");
	fprintf(stderr,"\t[-o2]  Output File For DLG Category #2 (outfile) [null]\n");
	fprintf(stderr,"\t[-o3]  Output File For DLG Category #3 (outfile) [null]\n");
	fprintf(stderr,"\t[-o4]  Output File For DLG Category #4 (outfile) [null]\n");
	fprintf(stderr,"\t[-x]  Number Of Columns In The Output Image (integer, > 0) [512]\n");
	fprintf(stderr, "\t[-l]  location options\n");
	fprintf(stderr, "\t\t0  (No Location Data),\n");
	fprintf(stderr, "\t\t1  (Sparse Location Data),\n");
	fprintf(stderr, "\t\tor 2  (Full Location Data)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dlg2viff\n");
	fprintf(stderr, "\t[-U] Gives the usage for dlg2viff\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dlg2viff.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dlg2viff.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dlg2viff
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) Input DLG File \n        {infile}: "; 
char	*o1_pstr = 
	"\nEnter: (o1) Output File For DLG Category #1 \n        {outfile}: "; 
char	*o2_pstr = 
	"\nEnter: (o2) Output File For DLG Category #2 \n        {outfile}: "; 
char	*o3_pstr = 
	"\nEnter: (o3) Output File For DLG Category #3 \n        {outfile}: "; 
char	*o4_pstr = 
	"\nEnter: (o4) Output File For DLG Category #4 \n        {outfile}: "; 
char	*x_pstr = 
	"\nEnter: (x) Number Of Columns In The Output Image \n        {integer, > 0 [512] }: "; 
char	*l_pstr = "\nEnter: (l) location options -- \n      \t\t0 (No Location Data)\n\t\t1 (Sparse Location Data)\n\t\tor 2 (Full Location Data)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dlg2viff", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dlg2viff.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dlg2viff: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dlg2viff.ans");
		}

	     }

	}

	/*
	 * allocate the dlg2viff structure
	 */
	dlg2viff = (dlg2viff_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dlg2viff_struct));

	/*
	 * get required arguments for dlg2viff
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dlg2viff->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dlg2viff->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dlg2viff->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dlg2viff->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dlg2viff->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dlg2viff
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dlg2viff->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(dlg2viff->o1_file))
;

	dlg2viff->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(dlg2viff->o2_file))
;

	dlg2viff->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(dlg2viff->o3_file))
;

	dlg2viff->o4_flag = vget_outfile(fid, prompt_flag,
	"-o4", o4_pstr, &(dlg2viff->o4_file))
;

	dlg2viff->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(dlg2viff->x_int),
	512, 2, 2);


	/*
	 * get optional toggles for dlg2viff
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dlg2viff->l_flag = vget_int(fid, prompt_flag,
		"-l", l_pstr, &(dlg2viff->l_toggle),
		0, 0, 0);

		if ((dlg2viff->l_toggle == 0 ) || 
		    (dlg2viff->l_toggle == 1 ) || 
		    (dlg2viff->l_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dlg2viff->l_flag = vget_int(fid, prompt_flag,
		"-l", l_pstr, &(dlg2viff->l_toggle),
		0, 0, 0);

		if ((dlg2viff->l_toggle != 0 ) && 
		    (dlg2viff->l_toggle != 1 ) && 
		    (dlg2viff->l_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



