 /*
  * Khoros: $Id: dwindow.c,v 1.2 1992/03/20 23:34:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dwindow.c,v 1.2 1992/03/20 23:34:57 dkhoros Exp $";
#endif

 /*
  * $Log: dwindow.c,v $
 * Revision 1.2  1992/03/20  23:34:57  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dwindow.c
 >>>>
 >>>>      Program Name: dwindow
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D Window (Apodization) Functions.
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Glen Abousleman
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:37:03 1992
 >>>>
 >>>>          Routines: main- the main program for dwindow
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dwindow.h"


/****************************************************************
 *
 * Routine Name:  main program for dwindow
 *
 *       Input:  
 *         -i  input data file (xviff file) 
 *         -o  resulting output file (xviff file) 
 *
 *
 *         [-k] desired THETA parameter for Kaiser window 
 *         [-e] desired damping parameter for Exponential window  (value >= 0.0)
 *         [-b] desired window width for User defined window  (value >= 0)
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *         [-w] windowed output file to be created
 *		0 (selection of Rectangular window ),
 *		1 (selection of Bartlett window ),
 *		2 (selection of Hamming window),
 *		3 (selection of Hanning window),
 *		4 (selection of Parzen window),
 *		5 (selection of Kaiser window),
 *		6 (selection of Exponential window),
 *		7 (selection of Blackman window),
 *		8 (selection of Blackman-Harris window),
 *		9 (selection of Right-Triangular window),
 *		10 (selection of Left-Triangular window),
 *		11 (selection of Right-Exponential window),
 *		12 (selection of Left-Exponential window),
 *		or 13 (selection of Left-Triangular window)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
int    window_option, width, procdir;
float  theta, damp;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
   if (check_args()) exit(1);
   READIMAGE(image);
   CHECKTYPE(program,image);
   CHECKINPUT(program,image);
   theta = dwindow->k_float;
   damp = dwindow->e_float;
   width = dwindow->b_int;
   window_option = dwindow->w_toggle;
   procdir = dwindow->d_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldwindow ( image, window_option, theta, damp, width, procdir ) )
        {
            (void) fprintf(stderr, "ldwindow Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dwindow->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dwindow 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dwindow :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D Window (Apodization) Functions.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
(void) fprintf(stderr,"where \"w\" is the window function to be used:\n");
(void) fprintf(stderr,"\t\"w=0\" Rectangular window\n");
(void) fprintf(stderr,"\t\"w=1\" Bartlett window\n");
(void) fprintf(stderr,"\t\"w=2\" Hamming window\n");
(void) fprintf(stderr,"\t\"w=3\" Hanning window\n");
(void) fprintf(stderr,"\t\"w=4\" Parzen window\n");
(void) fprintf(stderr,"\t\"w=5\" Kaiser window\n");
(void) fprintf(stderr,"\t\"w=6\" Exponential window\n");
(void) fprintf(stderr,"\t\"w=7\" Blackman window\n");
(void) fprintf(stderr,"\t\"w=8\" Blackman-Harris window\n");
(void) fprintf(stderr,"\t\"w=9\" Right-Triangular window\n");
(void) fprintf(stderr,"\t\"w=10\" Left-Triangular window\n");
(void) fprintf(stderr,"\t\"w=11\" Right-Exponential window\n");
(void) fprintf(stderr,"\t\"w=12\" Left-Exponential window\n");
(void) fprintf(stderr,"\t\"w=13\" User Defined Triangular window\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-k]  desired THETA parameter for Kaiser window (float) [1]\n");
	fprintf(stderr,"\t[-e]  desired damping parameter for Exponential window (float, >= 0.0) [1]\n");
	fprintf(stderr,"\t[-b]  desired window width for User defined window (integer, >= 0) [1]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-w]  windowed output file to be created\n");
	fprintf(stderr, "\t\t0  (selection of Rectangular window ),\n");
	fprintf(stderr, "\t\t1  (selection of Bartlett window ),\n");
	fprintf(stderr, "\t\t2  (selection of Hamming window),\n");
	fprintf(stderr, "\t\t3  (selection of Hanning window),\n");
	fprintf(stderr, "\t\t4  (selection of Parzen window),\n");
	fprintf(stderr, "\t\t5  (selection of Kaiser window),\n");
	fprintf(stderr, "\t\t6  (selection of Exponential window),\n");
	fprintf(stderr, "\t\t7  (selection of Blackman window),\n");
	fprintf(stderr, "\t\t8  (selection of Blackman-Harris window),\n");
	fprintf(stderr, "\t\t9  (selection of Right-Triangular window),\n");
	fprintf(stderr, "\t\t10  (selection of Left-Triangular window),\n");
	fprintf(stderr, "\t\t11  (selection of Right-Exponential window),\n");
	fprintf(stderr, "\t\t12  (selection of Left-Exponential window),\n");
	fprintf(stderr, "\t\tor 13  (selection of Left-Triangular window)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dwindow\n");
	fprintf(stderr, "\t[-U] Gives the usage for dwindow\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dwindow.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dwindow.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dwindow
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*k_pstr = 
	"\nEnter: (k) desired THETA parameter for Kaiser window \n        {float [1.000000] }: "; 
char	*e_pstr = 
	"\nEnter: (e) desired damping parameter for Exponential window \n        {float, >= 0.0 [1.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) desired window width for User defined window \n        {integer, >= 0 [1] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*w_pstr = "\nEnter: (w) windowed output file to be created -- \n      \t\t0 (selection of Rectangular window )\n\t\t1 (selection of Bartlett window )\n\t\t2 (selection of Hamming window)\n\t\t3 (selection of Hanning window)\n\t\t4 (selection of Parzen window)\n\t\t5 (selection of Kaiser window)\n\t\t6 (selection of Exponential window)\n\t\t7 (selection of Blackman window)\n\t\t8 (selection of Blackman-Harris window)\n\t\t9 (selection of Right-Triangular window)\n\t\t10 (selection of Left-Triangular window)\n\t\t11 (selection of Right-Exponential window)\n\t\t12 (selection of Left-Exponential window)\n\t\tor 13 (selection of Left-Triangular window)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dwindow", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dwindow.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dwindow: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dwindow.ans");
		}

	     }

	}

	/*
	 * allocate the dwindow structure
	 */
	dwindow = (dwindow_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dwindow_struct));

	/*
	 * get required arguments for dwindow
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dwindow->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dwindow->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dwindow->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dwindow->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dwindow->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dwindow->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dwindow->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dwindow->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dwindow->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dwindow->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dwindow
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dwindow->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(dwindow->k_float),
	1.000000, 3.000000, 3.000000);

	dwindow->e_flag = vget_float(fid, prompt_flag,
	"-e", e_pstr, &(dwindow->e_float),
	1.000000, 1.000000, 1.000000);

	dwindow->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(dwindow->b_int),
	1, 1, 1);

	dwindow->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dwindow->d_logic), 1);


	/*
	 * get optional toggles for dwindow
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dwindow->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dwindow->w_toggle),
		0, 0, 0);

		if ((dwindow->w_toggle == 0 ) || 
		    (dwindow->w_toggle == 1 ) || 
		    (dwindow->w_toggle == 2 ) || 
		    (dwindow->w_toggle == 3 ) || 
		    (dwindow->w_toggle == 4 ) || 
		    (dwindow->w_toggle == 5 ) || 
		    (dwindow->w_toggle == 6 ) || 
		    (dwindow->w_toggle == 7 ) || 
		    (dwindow->w_toggle == 8 ) || 
		    (dwindow->w_toggle == 9 ) || 
		    (dwindow->w_toggle == 10 ) || 
		    (dwindow->w_toggle == 11 ) || 
		    (dwindow->w_toggle == 12 ) || 
		    (dwindow->w_toggle == 13 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dwindow->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dwindow->w_toggle),
		0, 0, 0);

		if ((dwindow->w_toggle != 0 ) && 
		    (dwindow->w_toggle != 1 ) && 
		    (dwindow->w_toggle != 2 ) && 
		    (dwindow->w_toggle != 3 ) && 
		    (dwindow->w_toggle != 4 ) && 
		    (dwindow->w_toggle != 5 ) && 
		    (dwindow->w_toggle != 6 ) && 
		    (dwindow->w_toggle != 7 ) && 
		    (dwindow->w_toggle != 8 ) && 
		    (dwindow->w_toggle != 9 ) && 
		    (dwindow->w_toggle != 10 ) && 
		    (dwindow->w_toggle != 11 ) && 
		    (dwindow->w_toggle != 12 ) && 
		    (dwindow->w_toggle != 13 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



