 /*
  * Khoros: $Id: dxcorr.c,v 1.2 1992/03/20 23:19:24 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dxcorr.c,v 1.2 1992/03/20 23:19:24 dkhoros Exp $";
#endif

 /*
  * $Log: dxcorr.c,v $
 * Revision 1.2  1992/03/20  23:19:24  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dxcorr.c
 >>>>
 >>>>      Program Name: dxcorr
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Cross-correlation sequence of 1-D signals.
 >>>>	
 >>>>	

 >>>>            Author: Ramiro Jordan, Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 12:06:56 1992
 >>>>
 >>>>          Routines: main- the main program for dxcorr
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dxcorr.h"


/****************************************************************
 *
 * Routine Name:  main program for dxcorr
 *
 *       Input:  
 *        -i1  input first file (xviff file) 
 *        -i2  input second file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-s] number of points for cross-correlation sequence  (value > 0)
 *        [-j] define arithmetic on data
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-g] type of cross-correlation file to be created
 *		0 (choose biased cross-correlation estimate),
 *		1 (choose unbiased cross-correlation estimate),
 *		or 2 (choose FFT based cross-correlation estimate)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image1, *image2, *readimage();
int    out_option, arith_type, points, process_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);
READIMAGE(image1,image2);
CHECKTYPE(program, image1, image2);
CHECKINPUT(program, image1, image2);
arith_type = dxcorr->j_logic;
out_option = dxcorr->g_toggle;
points = dxcorr->s_int;
process_dir = dxcorr->d_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldxcorr ( image1, image2, arith_type, out_option, points, process_dir ) )
        {
            (void) fprintf(stderr, "ldxcorr Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dxcorr->o_file,image1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dxcorr 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dxcorr :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCross-correlation sequence of 1-D signals.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input first file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-i2  input second file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  number of points for cross-correlation sequence (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-j]  define arithmetic on data (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-g]  type of cross-correlation file to be created\n");
	fprintf(stderr, "\t\t0  (choose biased cross-correlation estimate),\n");
	fprintf(stderr, "\t\t1  (choose unbiased cross-correlation estimate),\n");
	fprintf(stderr, "\t\tor 2  (choose FFT based cross-correlation estimate)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dxcorr\n");
	fprintf(stderr, "\t[-U] Gives the usage for dxcorr\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dxcorr.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dxcorr.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dxcorr
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input first file (xviff file) \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input second file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) number of points for cross-correlation sequence \n        {integer, > 0 [256] }: "; 
char	*j_pstr = 
	"\nEnter: (j) define arithmetic on data \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*g_pstr = "\nEnter: (g) type of cross-correlation file to be created -- \n      \t\t0 (choose biased cross-correlation estimate)\n\t\t1 (choose unbiased cross-correlation estimate)\n\t\tor 2 (choose FFT based cross-correlation estimate)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dxcorr", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dxcorr.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dxcorr: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dxcorr.ans");
		}

	     }

	}

	/*
	 * allocate the dxcorr structure
	 */
	dxcorr = (dxcorr_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dxcorr_struct));

	/*
	 * get required arguments for dxcorr
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dxcorr->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(dxcorr->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dxcorr->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    dxcorr->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(dxcorr->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dxcorr->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(dxcorr->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dxcorr->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    dxcorr->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dxcorr->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dxcorr->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dxcorr->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dxcorr->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dxcorr->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dxcorr->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dxcorr
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dxcorr->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(dxcorr->s_int),
	256, 2, 2);

	dxcorr->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dxcorr->j_logic), 1);

	dxcorr->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dxcorr->d_logic), 1);


	/*
	 * get optional toggles for dxcorr
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dxcorr->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dxcorr->g_toggle),
		0, 0, 0);

		if ((dxcorr->g_toggle == 0 ) || 
		    (dxcorr->g_toggle == 1 ) || 
		    (dxcorr->g_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dxcorr->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dxcorr->g_toggle),
		0, 0, 0);

		if ((dxcorr->g_toggle != 0 ) && 
		    (dxcorr->g_toggle != 1 ) && 
		    (dxcorr->g_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



