 /*
  * Khoros: $Id: dgpwl.c,v 1.3 1992/03/20 23:16:58 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dgpwl.c,v 1.3 1992/03/20 23:16:58 dkhoros Exp $";
#endif

 /*
  * $Log: dgpwl.c,v $
 * Revision 1.3  1992/03/20  23:16:58  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dgpwl.c
 >>>>
 >>>>      Program Name: dgpwl
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a set of piecewise linear periodic signals.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 14:20:53 1992
 >>>>
 >>>>          Routines: main- the main program for dgpwl
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dgpwl.h"


/****************************************************************
 *
 * Routine Name:  main program for dgpwl
 *
 *       Input:  
 *       -o  resulting image 
 *
 *
 *       [-i] input value file (xviff file)
 *       [-trigger] trigger input
 *       [-v] number of vectors  (value > 0)
 *       [-n] number of points  (value > 0)
 *       [-s] sampling frequency  (value > 0.0)
 *       [-l] signal minimum 
 *       [-m] signal maximum 
 *       [-p] signal period  (value > 0.0)
 *       [-r] rise time   (value >= 0.0)
 *       [-f] fall time   (value >= 0.0)
 *       [-w] pulse width   (value >= 0.0)
 *       [-b] initial delay  (value >= 0)
 *       [-d] data processing direction (0 = down vectors, 1 = across bands)
 *       [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image=NULL, *kernel=NULL, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,dgpwl->t_toggle)){
     fprintf(stderr,"dgpwl:  Invalid data type specified\n");
     exit(1);
  }

/*
** load kernel if necessary
*/

  if (dgpwl->i_flag) {
    image = readimage(dgpwl->i_file);
    if(image == NULL)
    {
      (void)fprintf(stderr,"dgpwl:  Value file could not be read!\n");
      exit(1);
    }
  }

/* -main_before_lib_call_end */

/* -main_library_call */

  if(!ldgpwl(&image,dgpwl->v_int,dgpwl->n_int,dgpwl->s_float,
             dgpwl->l_float,dgpwl->m_float,dgpwl->p_float,
             dgpwl->r_float,dgpwl->f_float,dgpwl->w_float,dgpwl->b_int,type,
             dgpwl->d_logic)){
    (void)fprintf(stderr, "ldgpwl Failed\n");
    exit(1);
  }


/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(dgpwl->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dgpwl 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dgpwl :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a set of piecewise linear periodic signals.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-i]  input value file (xviff file) (infile) [null]\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-v]  number of vectors (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-n]  number of points (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-s]  sampling frequency (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-l]  signal minimum (float) [0]\n");
	fprintf(stderr,"\t[-m]  signal maximum (float) [1]\n");
	fprintf(stderr,"\t[-p]  signal period (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-r]  rise time  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-f]  fall time  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-w]  pulse width  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-b]  initial delay (integer, >= 0) [0]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dgpwl\n");
	fprintf(stderr, "\t[-U] Gives the usage for dgpwl\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dgpwl.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dgpwl.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dgpwl
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*i_pstr = 
	"\nEnter: (i) input value file (xviff file) \n        {infile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*v_pstr = 
	"\nEnter: (v) number of vectors \n        {integer, > 0 [1] }: "; 
char	*n_pstr = 
	"\nEnter: (n) number of points \n        {integer, > 0 [256] }: "; 
char	*s_pstr = 
	"\nEnter: (s) sampling frequency \n        {float, > 0.0 [2.000000] }: "; 
char	*l_pstr = 
	"\nEnter: (l) signal minimum \n        {float [0.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) signal maximum \n        {float [1.000000] }: "; 
char	*p_pstr = 
	"\nEnter: (p) signal period \n        {float, > 0.0 [1.000000] }: "; 
char	*r_pstr = 
	"\nEnter: (r) rise time  \n        {float, >= 0.0 [0.000000] }: "; 
char	*f_pstr = 
	"\nEnter: (f) fall time  \n        {float, >= 0.0 [0.000000] }: "; 
char	*w_pstr = 
	"\nEnter: (w) pulse width  \n        {float, >= 0.0 [0.000000] }: "; 
char	*b_pstr = 
	"\nEnter: (b) initial delay \n        {integer, >= 0 [0] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dgpwl", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dgpwl.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dgpwl: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dgpwl.ans");
		}

	     }

	}

	/*
	 * allocate the dgpwl structure
	 */
	dgpwl = (dgpwl_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dgpwl_struct));

	/*
	 * get required arguments for dgpwl
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dgpwl->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dgpwl->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dgpwl->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dgpwl->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dgpwl->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dgpwl
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dgpwl->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(dgpwl->i_file))
;

	dgpwl->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(dgpwl->trigger_file))
;

	dgpwl->v_flag = vget_int(fid, prompt_flag,
	"-v", v_pstr, &(dgpwl->v_int),
	1, 2, 2);

	dgpwl->n_flag = vget_int(fid, prompt_flag,
	"-n", n_pstr, &(dgpwl->n_int),
	256, 2, 2);

	dgpwl->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(dgpwl->s_float),
	2.000000, 2.000000, 2.000000);

	dgpwl->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(dgpwl->l_float),
	0.000000, 0.000000, 0.000000);

	dgpwl->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(dgpwl->m_float),
	1.000000, 0.000000, 0.000000);

	dgpwl->p_flag = vget_float(fid, prompt_flag,
	"-p", p_pstr, &(dgpwl->p_float),
	1.000000, 2.000000, 2.000000);

	dgpwl->r_flag = vget_float(fid, prompt_flag,
	"-r", r_pstr, &(dgpwl->r_float),
	0.000000, 1.000000, 1.000000);

	dgpwl->f_flag = vget_float(fid, prompt_flag,
	"-f", f_pstr, &(dgpwl->f_float),
	0.000000, 1.000000, 1.000000);

	dgpwl->w_flag = vget_float(fid, prompt_flag,
	"-w", w_pstr, &(dgpwl->w_float),
	0.000000, 1.000000, 1.000000);

	dgpwl->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(dgpwl->b_int),
	0, 1, 1);

	dgpwl->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dgpwl->d_logic), 1);


	/*
	 * get optional toggles for dgpwl
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dgpwl->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgpwl->t_toggle),
		"float");

		if (((strcmp(dgpwl->t_toggle, "float") == 0)) || 
		     ((strcmp(dgpwl->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dgpwl->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(dgpwl->t_toggle),
		"float");

		if (((strcmp(dgpwl->t_toggle, "float") != 0)) && 
		     ((strcmp(dgpwl->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



