 /*
  * Khoros: $Id: dfilthp.c,v 1.3 1992/03/20 23:23:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfilthp.c,v 1.3 1992/03/20 23:23:45 dkhoros Exp $";
#endif

 /*
  * $Log: dfilthp.c,v $
 * Revision 1.3  1992/03/20  23:23:45  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfilthp.c
 >>>>
 >>>>      Program Name: dfilthp
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	1D highpass frequency domain filter design
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Vena Margo
 >>>>
 >>>> Date Last Updated: Mon Mar  9 20:18:08 1992
 >>>>
 >>>>          Routines: main- the main program for dfilthp
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfilthp.h"


/****************************************************************
 *
 * Routine Name:  main program for dfilthp
 *
 *       Input:  
 *         -o  resulting output file (ascii polynomial file) 
 *
 *
 *         [-h] sampling frequency in hertz  (value > 0.0)
 *         [-f1] digital rejection frequency  (value > 0.0)
 *         [-f2] digital cutoff frequency  (value > 0.0)
 *         [-tc] gain at passband edge  (0.000 < value < 1.000)
 *         [-tr] gain at stopband edge  (0.000 < value < 1.000)
 *         [-c] filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)
 *		0 (butterworth),
 *		1 (chebychev i),
 *		or 2 (chebychev ii)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    int stages, class;
    float f1,f2,sfreq,tolr,tolc; 
    struct  poly_struct *poly = NULL;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    f1 = dfilthp->f1_float;
    f2 = dfilthp->f2_float;

    tolr = dfilthp->tr_float;
    tolc = dfilthp->tc_float;
    class = dfilthp->c_toggle;
    sfreq = dfilthp->h_float;

/*
** allocate memory for junk passed into writepoly()
*/

  if(!createpoly(&poly,MAXPOLYS,MAXTERMS,MAXSTAGES,STRMAX)){
     fprintf(stderr,"%s:  failure to create polynomial.\n",program);
     exit(1);
  }

/* -main_before_lib_call_end */

/* -main_library_call */
    if(!ldfilthp(poly,f1,f2,tolc,tolr,sfreq,class)){
       fprintf(stderr,"%s:  call to ldfilthp failed.\n",program);
       exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writepoly(dfilthp->o_file,poly,1,"filter created by dfilthp");
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfilthp 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfilthp :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t1D highpass frequency domain filter design\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting output file (ascii polynomial file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-h]  sampling frequency in hertz (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-f1]  digital rejection frequency (float, > 0.0) [0.25]\n");
	fprintf(stderr,"\t[-f2]  digital cutoff frequency (float, > 0.0) [0.4]\n");
	fprintf(stderr,"\t[-tc]  gain at passband edge (float,  0.000 to 1.000) [0.707]\n");
	fprintf(stderr,"\t[-tr]  gain at stopband edge (float,  0.000 to 1.000) [0.316]\n");
	fprintf(stderr, "\t[-c]  filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)\n");
	fprintf(stderr, "\t\t0  (butterworth),\n");
	fprintf(stderr, "\t\t1  (chebychev i),\n");
	fprintf(stderr, "\t\tor 2  (chebychev ii)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfilthp\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfilthp\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfilthp.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfilthp.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfilthp
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting output file (ascii polynomial file) \n        {outfile}: "; 
char	*h_pstr = 
	"\nEnter: (h) sampling frequency in hertz \n        {float, > 0.0 [1.000000] }: "; 
char	*f1_pstr = 
	"\nEnter: (f1) digital rejection frequency \n        {float, > 0.0 [0.250000] }: "; 
char	*f2_pstr = 
	"\nEnter: (f2) digital cutoff frequency \n        {float, > 0.0 [0.400000] }: "; 
char	*tc_pstr = 
	"\nEnter: (tc) gain at passband edge \n        {float,  0.000 to 1.000 [0.707000] }: "; 
char	*tr_pstr = 
	"\nEnter: (tr) gain at stopband edge \n        {float,  0.000 to 1.000 [0.316000] }: "; 
char	*c_pstr = "\nEnter: (c) filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) -- \n      \t\t0 (butterworth)\n\t\t1 (chebychev i)\n\t\tor 2 (chebychev ii)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfilthp", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfilthp.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfilthp: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfilthp.ans");
		}

	     }

	}

	/*
	 * allocate the dfilthp structure
	 */
	dfilthp = (dfilthp_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfilthp_struct));

	/*
	 * get required arguments for dfilthp
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfilthp->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfilthp->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfilthp->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfilthp->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfilthp->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfilthp
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfilthp->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(dfilthp->h_float),
	1.000000, 2.000000, 2.000000);

	dfilthp->f1_flag = vget_float(fid, prompt_flag,
	"-f1", f1_pstr, &(dfilthp->f1_float),
	0.250000, 2.000000, 2.000000);

	dfilthp->f2_flag = vget_float(fid, prompt_flag,
	"-f2", f2_pstr, &(dfilthp->f2_float),
	0.400000, 2.000000, 2.000000);

	dfilthp->tc_flag = vget_float(fid, prompt_flag,
	"-tc", tc_pstr, &(dfilthp->tc_float),
	0.707000, 0.000000, 1.000000);

	dfilthp->tr_flag = vget_float(fid, prompt_flag,
	"-tr", tr_pstr, &(dfilthp->tr_float),
	0.316000, 0.000000, 1.000000);


	/*
	 * get optional toggles for dfilthp
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dfilthp->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfilthp->c_toggle),
		0, 0, 0);

		if ((dfilthp->c_toggle == 0 ) || 
		    (dfilthp->c_toggle == 1 ) || 
		    (dfilthp->c_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dfilthp->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfilthp->c_toggle),
		0, 0, 0);

		if ((dfilthp->c_toggle != 0 ) && 
		    (dfilthp->c_toggle != 1 ) && 
		    (dfilthp->c_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



