 /*
  * Khoros: $Id: dfiltbs.c,v 1.3 1992/03/20 23:24:32 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dfiltbs.c,v 1.3 1992/03/20 23:24:32 dkhoros Exp $";
#endif

 /*
  * $Log: dfiltbs.c,v $
 * Revision 1.3  1992/03/20  23:24:32  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfiltbs.c
 >>>>
 >>>>      Program Name: dfiltbs
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	designs bandstop filters
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Mon Mar  9 20:17:18 1992
 >>>>
 >>>>          Routines: main- the main program for dfiltbs
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dfiltbs.h"


/****************************************************************
 *
 * Routine Name:  main program for dfiltbs
 *
 *       Input:  
 *         -o  resulting output file (polynomial file) 
 *
 *
 *         [-h] sampling frequency in hertz  (value > 0.0)
 *         [-f1] lower rejection frequency  (value > 0.0)
 *         [-f2] lower cutoff frequency  (value > 0.0)
 *         [-f3] upper cutoff frequency  (value > 0.0)
 *         [-f4] upper rejection frequency  (value > 0.0)
 *         [-tc] gain at passband edges   (0.000 < value < 1.000)
 *         [-tr] gain at stopband edges   (0.000 < value < 1.000)
 *         [-c] filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)
 *		0 (butterworth),
 *		1 (chebychev i),
 *		or 2 (chebychev ii)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    int stages, class;
    float f1,f2,f3,f4,sfreq,tolr,tolc; 
    struct  poly_struct *poly = NULL;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    f1 = dfiltbs->f1_float;
    f2 = dfiltbs->f2_float;
    f3 = dfiltbs->f3_float;
    f4 = dfiltbs->f4_float;

    tolr = dfiltbs->tr_float;
    tolc = dfiltbs->tc_float;
    class = dfiltbs->c_toggle;
    sfreq = dfiltbs->h_float;

/*
** allocate memory for junk passed into writepoly()
*/

  if(!createpoly(&poly,MAXPOLYS,MAXTERMS,MAXSTAGES,STRMAX)){
     fprintf(stderr,"%s:  failure to create polynomial.\n",program);
     exit(1);
  }
  strcpy(poly->func_name,FUNC_NAME);
  strcpy(poly->indep_var,INDEP_VAR);
/* -main_before_lib_call_end */

/* -main_library_call */
    if(!ldfiltbs(poly,f1,f2,f3,f4,tolc,tolr,sfreq,class)){
       fprintf(stderr,"%s:  call to ldfiltbs failed.\n",program);
       exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writepoly(dfiltbs->o_file,poly,1,"filter created by dfiltbs");
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dfiltbs 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dfiltbs :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tdesigns bandstop filters\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting output file (polynomial file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-h]  sampling frequency in hertz (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-f1]  lower rejection frequency (float, > 0.0) [0.1]\n");
	fprintf(stderr,"\t[-f2]  lower cutoff frequency (float, > 0.0) [0.2]\n");
	fprintf(stderr,"\t[-f3]  upper cutoff frequency (float, > 0.0) [0.3]\n");
	fprintf(stderr,"\t[-f4]  upper rejection frequency (float, > 0.0) [0.4]\n");
	fprintf(stderr,"\t[-tc]  gain at passband edges  (float,  0.000 to 1.000) [0.707]\n");
	fprintf(stderr,"\t[-tr]  gain at stopband edges  (float,  0.000 to 1.000) [0.316]\n");
	fprintf(stderr, "\t[-c]  filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii)\n");
	fprintf(stderr, "\t\t0  (butterworth),\n");
	fprintf(stderr, "\t\t1  (chebychev i),\n");
	fprintf(stderr, "\t\tor 2  (chebychev ii)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dfiltbs\n");
	fprintf(stderr, "\t[-U] Gives the usage for dfiltbs\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dfiltbs.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dfiltbs.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dfiltbs
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting output file (polynomial file) \n        {outfile}: "; 
char	*h_pstr = 
	"\nEnter: (h) sampling frequency in hertz \n        {float, > 0.0 [1.000000] }: "; 
char	*f1_pstr = 
	"\nEnter: (f1) lower rejection frequency \n        {float, > 0.0 [0.100000] }: "; 
char	*f2_pstr = 
	"\nEnter: (f2) lower cutoff frequency \n        {float, > 0.0 [0.200000] }: "; 
char	*f3_pstr = 
	"\nEnter: (f3) upper cutoff frequency \n        {float, > 0.0 [0.300000] }: "; 
char	*f4_pstr = 
	"\nEnter: (f4) upper rejection frequency \n        {float, > 0.0 [0.400000] }: "; 
char	*tc_pstr = 
	"\nEnter: (tc) gain at passband edges  \n        {float,  0.000 to 1.000 [0.707000] }: "; 
char	*tr_pstr = 
	"\nEnter: (tr) gain at stopband edges  \n        {float,  0.000 to 1.000 [0.316000] }: "; 
char	*c_pstr = "\nEnter: (c) filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) -- \n      \t\t0 (butterworth)\n\t\t1 (chebychev i)\n\t\tor 2 (chebychev ii)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dfiltbs", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dfiltbs.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dfiltbs: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dfiltbs.ans");
		}

	     }

	}

	/*
	 * allocate the dfiltbs structure
	 */
	dfiltbs = (dfiltbs_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dfiltbs_struct));

	/*
	 * get required arguments for dfiltbs
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dfiltbs->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dfiltbs->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dfiltbs->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dfiltbs->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dfiltbs->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dfiltbs
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dfiltbs->h_flag = vget_float(fid, prompt_flag,
	"-h", h_pstr, &(dfiltbs->h_float),
	1.000000, 2.000000, 2.000000);

	dfiltbs->f1_flag = vget_float(fid, prompt_flag,
	"-f1", f1_pstr, &(dfiltbs->f1_float),
	0.100000, 2.000000, 2.000000);

	dfiltbs->f2_flag = vget_float(fid, prompt_flag,
	"-f2", f2_pstr, &(dfiltbs->f2_float),
	0.200000, 2.000000, 2.000000);

	dfiltbs->f3_flag = vget_float(fid, prompt_flag,
	"-f3", f3_pstr, &(dfiltbs->f3_float),
	0.300000, 2.000000, 2.000000);

	dfiltbs->f4_flag = vget_float(fid, prompt_flag,
	"-f4", f4_pstr, &(dfiltbs->f4_float),
	0.400000, 2.000000, 2.000000);

	dfiltbs->tc_flag = vget_float(fid, prompt_flag,
	"-tc", tc_pstr, &(dfiltbs->tc_float),
	0.707000, 0.000000, 1.000000);

	dfiltbs->tr_flag = vget_float(fid, prompt_flag,
	"-tr", tr_pstr, &(dfiltbs->tr_float),
	0.316000, 0.000000, 1.000000);


	/*
	 * get optional toggles for dfiltbs
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dfiltbs->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfiltbs->c_toggle),
		0, 0, 0);

		if ((dfiltbs->c_toggle == 0 ) || 
		    (dfiltbs->c_toggle == 1 ) || 
		    (dfiltbs->c_toggle == 2 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dfiltbs->c_flag = vget_int(fid, prompt_flag,
		"-c", c_pstr, &(dfiltbs->c_toggle),
		0, 0, 0);

		if ((dfiltbs->c_toggle != 0 ) && 
		    (dfiltbs->c_toggle != 1 ) && 
		    (dfiltbs->c_toggle != 2 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



