 /*
  * Khoros: $Id: createpoly.c,v 1.3 1992/03/20 23:24:46 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: createpoly.c,v 1.3 1992/03/20 23:24:46 dkhoros Exp $";
#endif

 /*
  * $Log: createpoly.c,v $
 * Revision 1.3  1992/03/20  23:24:46  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vinclude.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: createpoly.c                           <<<<
   >>>>                                                       <<<<
   >>>>   description: creates a polynomial structure         <<<<
   >>>>                                                       <<<<
   >>>>      routines: createpoly()			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>          NOTE: this routine is not for public use!    <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/***********************************************************************
*
*  Routine Name: createpoly 
*
*          Date: Tue Sep 25 16:04:53 MDT 1990
*         
*       Purpose: creates a polynomial structure for use with readpoly
*		 and writepoly.  It is simply a convienience..it also
*		 adds "orthogonality" with respect to createimage() 
*
*         Input: 
*
*        Output: 
*
*    Written By: Jeremy Worley
*
* Modifications:
*
***********************************************************************/
#include "vpoly.h"

#define FREEALL \
	for(j=0;j<i;j++){ \
		kfree((char *)(*poly)[i].terms); \
		kfree((char *)(*poly)[i].indep_var); \
		kfree((char *)(*poly)[i].func_name); \
	} \
	kfree((char *)poly); \

int createpoly(poly,npolys,nterms,nstages,dims)
    struct poly_struct **poly;
    int npolys,nterms,nstages,dims;
{
    int j,i;

    *poly=(struct poly_struct *)kmalloc(npolys*sizeof(struct poly_struct));
    if(poly==NULL){
       return(0);
    }

    for(i=0;i<npolys;i++){
        (*poly)[i].tdim = nterms;
        (*poly)[i].sdim = nstages;
        (*poly)[i].stages = 0;
        if(((*poly)[i].terms = (struct term_struct *)kmalloc(nterms*
                        sizeof(struct term_struct)))==NULL){
           FREEALL;
           return(0);
        }
        for(j=0;j<nterms;j++){
            if(((*poly)[i].terms[j].varname = (char *)kmalloc(dims*
		sizeof(char)))==NULL){
               FREEALL;
               return(0);
            }
            if(((*poly)[i].terms[j].fname = (char *)kmalloc(dims*
		sizeof(char)))==NULL){
               FREEALL;
               return(0);
            }
        }

        if(((*poly)[i].nterms = (int *)kmalloc(nstages*2*sizeof(int)))==
		NULL){
           FREEALL;
           return(0);
        }
        if(((*poly)[i].indep_var = (char *)kmalloc(dims*sizeof(char)))==
		NULL){
           FREEALL;
           return(0);
        }
        if(((*poly)[i].func_name = (char *)kmalloc(dims*sizeof(char)))==
		NULL){
           FREEALL;
           return(0);
        }
    }

    return(1);
}
