#! /bin/csh -f
#
#*----------------------------------------------------------------------
#*
#* Copyright 1991, University of New Mexico.  All rights reserved.
#*
#* Permission to copy and modify this software and its documen-
#* tation only for internal use in your organization is hereby
#* granted, provided that this notice is retained thereon and
#* on all copies.  UNM makes no representations as too the sui-
#* tability and operability of this software for any purpose.
#* It is provided "as is" without express or implied warranty.
#* 
#* UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
#* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
#* NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
#* INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
#* SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
#* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
#* ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
#* FORMANCE OF THIS SOFTWARE.
#* 
#* No other rights, including for example, the right to redis-
#* tribute this software and its documentation or the right to
#* prepare derivative works, are granted unless specifically
#* provided in a separate license agreement.
#*---------------------------------------------------------------------
#

#include "unmcopyright.h"	 /* Copyright 1991 by UNM */


#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
#  >>>>                                                       <<<<
#  >>>>	    file name: klndir_csh                             <<<<
#  >>>>                                                       <<<<
#  >>>>   description: utility for khoros source congiuration
#  >>>>                Makes symbolic linked source trees.    <<<<
#  >>>>                                                       <<<<
#  >>>> modifications: 3/4/91- Danielle Argiro, modified it 
#  >>>>               to be named 'klndir', put the ghost'ed 
#  >>>>               front end on, deleted shell script
#  >>>>               command line arg gathering/error checking.
#  >>>>                                                       <<<<
#  >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< 

# ROUTINE NAME:	klndir_csh
# 
# AUTHORS:	Ron E. Neher
# 
# DATE:		1/31/89
# 
# DESCRIPTION:	Script used to make symbolic linked source trees.  
# 
# MODIFICATIONS: 3/4/91- Danielle Argiro, modified it to be named 'klndir',
#                        put the ghost'ed front end on, deleted shell script
#                        command line arg gathering/error checking.
#
# CALLED FROM:  ksrcconf_csh
#

set noclobber
onintr cleanup
umask 000

set path = ( /usr/local/bin /usr/new /usr/ucb /usr/bin /bin \
    /usr/local/etc/ /usr/etc /etc/ /usr/hosts $KHOROS_HOME/bin . )

set SOURCEDIR  = $argv[1]
set DESTDIR    = $argv[2]

echo ""
echo  'klndir: SOURCEDIR = "'$SOURCEDIR'"'
echo  'klndir: DESTDIR   = "'$DESTDIR'"'
echo ""


    if (($SOURCEDIR == "") || ($DESTDIR == "")) goto cleanup

    if (! -d $SOURCEDIR) goto cleanup

    if ($SOURCEDIR == $DESTDIR) then
        echo "ERROR: source and destination directories are the same."
        goto cleanup
    endif


    if (! -d $DESTDIR) then
        set TMP_DIR = $DESTDIR
        set MK_DIRS = ( $TMP_DIR )
        while ($TMP_DIR:h != "")
            set TMP_DIR = $TMP_DIR:h
            set MK_DIRS = ( $TMP_DIR $MK_DIRS )
        end
        while ($#MK_DIRS)
            if (! -d $MK_DIRS[1]) then
                mkdir $MK_DIRS[1]
            endif
            shift MK_DIRS
        end
    else
        find $DESTDIR \( -type l \) -exec rm {} \;              	#CMMD#
        find $DESTDIR \( -name Makefile \) -exec rm {} \;               #CMMD#
    endif

    set SOURCEDIR_LIST = `(cd $SOURCEDIR; find * \( -type d \) -print)`

# go to Destination directory
#---------------------------------
    cd $DESTDIR

    foreach dir ($SOURCEDIR_LIST)
	if (! -e $dir) mkdir $dir
    end

# make the symbolic links for top directories in $SOURCEDIR
#------------------------------------------------------------
    set cpflg = 0
    set mkflg = 0
    foreach file ( `ls $SOURCEDIR` )
	if (! $cpflg) then
	    if ( ($file:e == "c") || ($file:e == "h") || \
	 	 ($file:e == "f") || ($file:e == "csh") || \
		 ($file:e == "pane") || ($file:e == "prog") || \
		 ($file:e == "ans") || ($file:e == "sh") || \
		 ($file:e == "conf") ) \
	 	 set cpflg = 1
	endif
        if (($file != "Makefile") && \
            (! -d $SOURCEDIR/$file) && (! -e $file)) then
            ln -s $SOURCEDIR/$file .
        else if ($file == "Makefile") then
            set mkflg = 1
        endif
    end
    if ($mkflg && $cpflg) then
        \rm -f Makefile
        cp $SOURCEDIR/Makefile .
    else if (($mkflg) && (! -e Makefile)) then
        cp $SOURCEDIR/Makefile .
    endif


# make the symbolic links for sub directories in $SOURCEDIR.  Copy
# over the source (*.c *.h) files.  And make symbolic links to
# the global Makefiles (makefiles that call other makefiles).
#------------------------------------------------------------
    foreach dir ($SOURCEDIR_LIST)
	echo -n "klndir: $dir ... "
	cd $dir
	set cpflg = 0
	set mkflg = 0
	foreach file (`ls $SOURCEDIR/$dir`)
	    if (! $cpflg) then
	        if ( ($file:e == "c") || ($file:e == "h") || \
	             ($file:e == "f") || ($file:e == "csh") || \
		     ($file:e == "pane") || ($file:e == "prog") || \
		     ($file:e == "ans") || ($file:e == "sh") || \
		     ($file:e == "conf") ) \
		     set cpflg = 1
	    endif
	    if (($file != "Makefile") && \
		(! -d $SOURCEDIR/$dir/$file) && (! -e $file)) then
		ln -s $SOURCEDIR/$dir/$file .		#CMMD#
	    else if ($file == "Makefile") then
		set mkflg = 1
	    endif
	end
	if ($mkflg && $cpflg) then
           \rm -f Makefile
           cp $SOURCEDIR/$dir/Makefile .
        else if (($mkflg) && (! -e Makefile)) then
           cp $SOURCEDIR/$dir/Makefile .
        endif
        echo "done"
        cd $DESTDIR
    end

    exit 0	# normal exit

cleanup:
