 /*
  * Khoros: $Id: cp_header.c,v 1.2 1992/03/20 23:40:15 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cp_header.c,v 1.2 1992/03/20 23:40:15 dkhoros Exp $";
#endif

 /*
  * $Log: cp_header.c,v $
 * Revision 1.2  1992/03/20  23:40:15  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	cp_header.c
# 
# AUTHORS:	Tom Sauer
# 
# DATE:		5/19/89
# 
# DESCRIPTION:	copy the header from one image to another
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: copyheader
*
*     PURPOSE: Copy the image header from one image to another
*
*       INPUT:  image1 -- the source image
*		image2 -- the destination image
*
*      OUTPUT: image2 - with the header from image 1
*
* CALLED FROM: 
*
* ROUTINES CALLED: 
*
**************************************************************/
copyheader(image1, image2)

struct xvimage *image1, *image2;
{

	image2->identifier = image1->identifier;
	image2->file_type = image1->file_type;
	image2->release = image1->release;
	image2->version = image1->version;
	image2->machine_dep = image1->machine_dep;
	(void) strcpy(image2->comment, image1->comment);
	image2->row_size = image1->row_size;
	image2->col_size = image1->col_size;
	image2->subrow_size = image1->subrow_size;
	image2->startx = image1->startx;
	image2->starty = image1->starty;
	image2->pixsizx = image1->pixsizx; 
	image2->pixsizy = image1->pixsizy;
	image2->location_type = image1->location_type;
	image2->location_dim = image1->location_dim;
	image2->num_of_images = image1->num_of_images;
	image2->num_data_bands = image1->num_data_bands;
	image2->data_storage_type = image1->data_storage_type;
	image2->data_encode_scheme = image1->data_encode_scheme;
	image2->map_scheme = image1->map_scheme;
	image2->map_storage_type = image1->map_storage_type;
	image2->map_row_size = image1->map_row_size;
	image2->map_col_size = image1->map_col_size;
	image2->map_subrow_size = image1->map_subrow_size;
	image2->map_enable = image1->map_enable;
	image2->maps_per_cycle = image1->maps_per_cycle;
	image2->color_space_model = image1->color_space_model;
	image2->ispare1 = image1->ispare1;
	image2->ispare2 = image1->ispare2;
	image2->fspare1 = image1->fspare1;
	image2->fspare2 = image1->fspare2;

}
