 /*
  * Khoros: $Id: copyimage.c,v 1.2 1991/12/18 09:55:54 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: copyimage.c,v 1.2 1991/12/18 09:55:54 dkhoros Exp $";
#endif

 /*
  * $Log: copyimage.c,v $
 * Revision 1.2  1991/12/18  09:55:54  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

/*
#
# FILE NAME:	copyimage.c
# 
# AUTHORS:	Scott Wilson
# 
# DATE:		5-Jan-91
# 
# DESCRIPTION:	copy  an image 
# 
# MODIFICATIONS:
# 
*/

/*INCLUDE*/
#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "viff.h"	 	
#include <stdio.h>

#define LENGTH 512

/**************************************************************
*
* MODULE NAME: copyimage
*
*     PURPOSE: Copy the image
*
*       INPUT:  image -- the source image
*
*      OUTPUT: 	1.  returns a pointer to an xvimage cloned from the input
*
* CALLED FROM: 
*
* ROUTINES CALLED: 
*
**************************************************************/
struct xvimage *copyimage(image)
struct xvimage *image;
{
        struct xvimage *copy;

        copy = (struct xvimage *)malloc(sizeof(struct xvimage));
        if (copy == NULL)
          {
            fprintf(stderr, "copyimage: unable to allocate header space\n");
            return(NULL);
          }

        copyheader(image,copy);

        if (copyimagedata(image,&copy,1) != 1)
          {
            fprintf(stderr,"copyimage: copyimagedata failed\n");
            freeimage(copy);
            return(NULL);
          }
        if (copylocationdata(image,&copy,1) != 1)
          {
            fprintf(stderr,"copyimage: copylocationdata failed\n");
            freeimage(copy);
            return(NULL);
          }
        if (copymapdata(image,&copy,1) != 1)
          {
            fprintf(stderr,"copyimage: copymapdata failed\n");
            freeimage(copy);
            return(NULL);
          }
        return(copy);
}
